/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.view.ui;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import lu.nowina.nexu.api.ConfiguredKeystore;
import lu.nowina.nexu.keystore.KeystoreProductAdapter;
import lu.nowina.nexu.view.core.AbstractUIOperationController;

public class SaveKeystoreController
extends AbstractUIOperationController<Boolean>
implements Initializable {
    @FXML
    private Button store;
    @FXML
    private Button forget;
    @FXML
    private Label message;
    @FXML
    private Label keystoreFilename;
    @FXML
    private Label keystoreType;
    private ResourceBundle resources;
    private KeystoreProductAdapter productAdapter;
    private ConfiguredKeystore keystore;

    public void initialize(URL location, ResourceBundle resources) {
        this.resources = resources;
        this.store.setOnAction(event -> {
            this.productAdapter.saveKeystore(this.keystore);
            this.signalEnd(true);
        });
        this.forget.setOnAction(e -> this.signalEnd(false));
    }

    @Override
    public void init(Object ... params) {
        this.productAdapter = (KeystoreProductAdapter)params[1];
        this.keystore = (ConfiguredKeystore)params[2];
        Platform.runLater(() -> {
            this.message.setText(MessageFormat.format(this.resources.getString("save.keystore.header"), params[0]));
            this.keystoreType.setText(this.keystore.getType().getLabel());
            this.keystoreFilename.setText(this.keystore.getUrl().substring(this.keystore.getUrl().lastIndexOf(47) + 1));
        });
    }
}

