/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.view.ui;

import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import lu.nowina.nexu.api.EnvironmentInfo;
import lu.nowina.nexu.api.OS;
import lu.nowina.nexu.flow.StageHelper;
import lu.nowina.nexu.model.Pkcs11Params;
import lu.nowina.nexu.view.core.AbstractUIOperationController;
import lu.nowina.nexu.view.core.ExtensionFilter;

public class Pkcs11ParamsController
extends AbstractUIOperationController<Pkcs11Params>
implements Initializable {
    private static final OS OS = EnvironmentInfo.buildFromSystemProperties(System.getProperties()).getOs();
    @FXML
    private Button ok;
    @FXML
    private Button cancel;
    @FXML
    private Button selectFile;
    private File pkcs11File;
    private final BooleanProperty pkcs11FileSpecified = new SimpleBooleanProperty(false);

    @Override
    public void init(Object ... params) {
        StageHelper.getInstance().setTitle((String)params[0], "pkcs11.params.title");
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.ok.setOnAction(event -> {
            Pkcs11Params result = new Pkcs11Params();
            result.setPkcs11Lib(this.pkcs11File);
            this.signalEnd(result);
        });
        this.ok.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.pkcs11FileSpecified));
        this.cancel.setOnAction(e -> this.signalUserCancel());
        this.selectFile.setOnAction(e -> {
            this.pkcs11File = this.getDisplay().displayFileChooser(new ExtensionFilter(OS.getNativeLibraryFileExtensionDescription(), OS.getNativeLibraryFileExtension()));
            this.pkcs11FileSpecified.set(this.pkcs11File != null);
        });
    }
}

