/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.rest;

import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.ToBeSigned;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import lu.nowina.nexu.api.AuthenticateRequest;
import lu.nowina.nexu.api.AuthenticateResponse;
import lu.nowina.nexu.api.CertificateFilter;
import lu.nowina.nexu.api.Execution;
import lu.nowina.nexu.api.Feedback;
import lu.nowina.nexu.api.FeedbackStatus;
import lu.nowina.nexu.api.GetCertificateRequest;
import lu.nowina.nexu.api.GetCertificateResponse;
import lu.nowina.nexu.api.GetIdentityInfoRequest;
import lu.nowina.nexu.api.GetIdentityInfoResponse;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.NexuRequest;
import lu.nowina.nexu.api.Purpose;
import lu.nowina.nexu.api.SignatureRequest;
import lu.nowina.nexu.api.SignatureResponse;
import lu.nowina.nexu.api.TokenId;
import lu.nowina.nexu.api.plugin.HttpPlugin;
import lu.nowina.nexu.api.plugin.HttpRequest;
import lu.nowina.nexu.api.plugin.HttpResponse;
import lu.nowina.nexu.api.plugin.HttpStatus;
import lu.nowina.nexu.api.plugin.InitializationMessage;
import lu.nowina.nexu.json.GsonHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestHttpPlugin
implements HttpPlugin {
    private static final Logger logger = LoggerFactory.getLogger(RestHttpPlugin.class.getName());

    @Override
    public List<InitializationMessage> init(String pluginId, NexuAPI api) {
        return Collections.emptyList();
    }

    @Override
    public HttpResponse process(NexuAPI api, HttpRequest req) throws Exception {
        String target = req.getTarget();
        logger.info("PathInfo " + target);
        String payload = IOUtils.toString(req.getInputStream());
        logger.info("Payload '" + payload + "'");
        switch (target) {
            case "/sign": {
                return this.signRequest(api, req, payload);
            }
            case "/certificates": {
                return this.getCertificates(api, req, payload);
            }
            case "/identityInfo": {
                return this.getIdentityInfo(api, payload);
            }
            case "/authenticate": {
                return this.authenticate(api, req, payload);
            }
        }
        throw new RuntimeException("Target not recognized " + target);
    }

    protected <T> Execution<T> returnNullIfValid(NexuRequest request) {
        return null;
    }

    private HttpResponse signRequest(NexuAPI api, HttpRequest req, String payload) {
        SignatureRequest r;
        logger.info("Signature");
        if (StringUtils.isEmpty(payload)) {
            String keyId;
            String tokenIdString;
            String digestAlgo;
            r = new SignatureRequest();
            String data = req.getParameter("dataToSign");
            if (data != null) {
                logger.info("Data to sign " + data);
                ToBeSigned tbs = new ToBeSigned();
                tbs.setBytes(DatatypeConverter.parseBase64Binary((String)data));
                r.setToBeSigned(tbs);
            }
            if ((digestAlgo = req.getParameter("digestAlgo")) != null) {
                logger.info("digestAlgo " + digestAlgo);
                r.setDigestAlgorithm(DigestAlgorithm.forName(digestAlgo, DigestAlgorithm.SHA256));
            }
            if ((tokenIdString = req.getParameter("tokenId")) != null) {
                TokenId tokenId = new TokenId(tokenIdString);
                r.setTokenId(tokenId);
            }
            if ((keyId = req.getParameter("keyId")) != null) {
                r.setKeyId(keyId);
            }
        } else {
            r = GsonHelper.fromJson(payload, SignatureRequest.class);
        }
        HttpResponse invalidRequestHttpResponse = this.checkRequestValidity(api, r);
        if (invalidRequestHttpResponse != null) {
            return invalidRequestHttpResponse;
        }
        logger.info("Call API");
        Execution<SignatureResponse> respObj = api.sign(r);
        return this.toHttpResponse(respObj);
    }

    private HttpResponse getCertificates(NexuAPI api, HttpRequest req, String payload) {
        GetCertificateRequest r;
        logger.info("API call certificates");
        if (StringUtils.isEmpty(payload)) {
            r = new GetCertificateRequest();
            String certificatePurpose = req.getParameter("certificatePurpose");
            if (certificatePurpose != null) {
                logger.info("Certificate purpose " + certificatePurpose);
                Purpose purpose = Enum.valueOf(Purpose.class, certificatePurpose);
                CertificateFilter certificateFilter = new CertificateFilter();
                certificateFilter.setPurpose(purpose);
                r.setCertificateFilter(certificateFilter);
            } else {
                String nonRepudiation = req.getParameter("nonRepudiation");
                if (StringUtils.isNotBlank(nonRepudiation)) {
                    CertificateFilter certificateFilter = new CertificateFilter();
                    certificateFilter.setNonRepudiationBit(Boolean.parseBoolean(nonRepudiation));
                    r.setCertificateFilter(certificateFilter);
                }
            }
        } else {
            r = GsonHelper.fromJson(payload, GetCertificateRequest.class);
        }
        HttpResponse invalidRequestHttpResponse = this.checkRequestValidity(api, r);
        if (invalidRequestHttpResponse != null) {
            return invalidRequestHttpResponse;
        }
        logger.info("Call API");
        Execution<GetCertificateResponse> respObj = api.getCertificate(r);
        return this.toHttpResponse(respObj);
    }

    private HttpResponse getIdentityInfo(NexuAPI api, String payload) {
        logger.info("API call get identity info");
        GetIdentityInfoRequest r = StringUtils.isEmpty(payload) ? new GetIdentityInfoRequest() : GsonHelper.fromJson(payload, GetIdentityInfoRequest.class);
        HttpResponse invalidRequestHttpResponse = this.checkRequestValidity(api, r);
        if (invalidRequestHttpResponse != null) {
            return invalidRequestHttpResponse;
        }
        logger.info("Call API");
        Execution<GetIdentityInfoResponse> respObj = api.getIdentityInfo(r);
        return this.toHttpResponse(respObj);
    }

    private HttpResponse authenticate(NexuAPI api, HttpRequest req, String payload) {
        AuthenticateRequest r;
        logger.info("Authenticate");
        if (StringUtils.isEmpty(payload)) {
            r = new AuthenticateRequest();
            String data = req.getParameter("challenge");
            if (data != null) {
                logger.info("Challenge " + data);
                ToBeSigned tbs = new ToBeSigned();
                tbs.setBytes(DatatypeConverter.parseBase64Binary((String)data));
                r.setChallenge(tbs);
            }
        } else {
            r = GsonHelper.fromJson(payload, AuthenticateRequest.class);
        }
        HttpResponse invalidRequestHttpResponse = this.checkRequestValidity(api, r);
        if (invalidRequestHttpResponse != null) {
            return invalidRequestHttpResponse;
        }
        logger.info("Call API");
        Execution<AuthenticateResponse> respObj = api.authenticate(r);
        return this.toHttpResponse(respObj);
    }

    private HttpResponse checkRequestValidity(NexuAPI api, NexuRequest request) {
        Execution verification = this.returnNullIfValid(request);
        if (verification != null) {
            Feedback feedback;
            if (verification.getFeedback() == null) {
                feedback = new Feedback();
                feedback.setFeedbackStatus(FeedbackStatus.SIGNATURE_VERIFICATION_FAILED);
                verification.setFeedback(feedback);
            } else {
                feedback = verification.getFeedback();
            }
            feedback.setInfo(api.getEnvironmentInfo());
            feedback.setNexuVersion(api.getAppConfig().getApplicationVersion());
            return this.toHttpResponse(verification);
        }
        return null;
    }

    private HttpResponse toHttpResponse(Execution<?> respObj) {
        if (respObj.isSuccess()) {
            return new HttpResponse(GsonHelper.toJson(respObj), "application/json;charset=UTF-8", HttpStatus.OK);
        }
        return new HttpResponse(GsonHelper.toJson(respObj), "application/json;charset=UTF-8", HttpStatus.ERROR);
    }
}

