/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;

public class NativeProcessExecutor {
    private final String command;
    private final long timeoutInMillis;
    private boolean executed;
    private String result;
    private int resultCode;

    public NativeProcessExecutor(String command, int timeoutInMillis) {
        this.command = command;
        this.timeoutInMillis = timeoutInMillis;
        this.executed = false;
        this.result = null;
        this.resultCode = -1;
    }

    public String getResult() {
        if (!this.executed) {
            this.execute();
        }
        if (this.resultCode != 0) {
            throw new IllegalStateException("Result code is " + this.resultCode);
        }
        return this.result;
    }

    public int getResultCode() {
        if (!this.executed) {
            this.execute();
        }
        return this.resultCode;
    }

    private void execute() {
        try {
            Process process = Runtime.getRuntime().exec(this.command);
            FutureTask<String> futureTask = new FutureTask<String>(new StreamReader(process.getInputStream()));
            Thread thread = new Thread(futureTask);
            thread.start();
            if (!process.waitFor(this.timeoutInMillis, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Timeout when executing command: " + this.command);
            }
            this.resultCode = process.exitValue();
            if (this.resultCode == 0) {
                this.result = futureTask.get();
            }
            this.executed = true;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException("An exception occurred when executing " + this.command, e);
        }
    }

    private static class StreamReader
    implements Callable<String> {
        private InputStream is;
        private StringWriter writer;

        public StreamReader(InputStream is) {
            this.is = is;
            this.writer = new StringWriter();
        }

        @Override
        public String call() {
            try {
                IOUtils.copy(this.is, (Writer)this.writer);
                String string = this.writer.toString();
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read InputStream", e);
            }
            finally {
                IOUtils.closeQuietly(this.is);
            }
        }
    }
}

