/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.keystore;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.MaskGenerationFunction;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.JKSSignatureToken;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.Pkcs12SignatureToken;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import lu.nowina.nexu.NexuException;
import lu.nowina.nexu.ProductDatabaseLoader;
import lu.nowina.nexu.api.CertificateFilter;
import lu.nowina.nexu.api.ConfiguredKeystore;
import lu.nowina.nexu.api.GetIdentityInfoResponse;
import lu.nowina.nexu.api.MessageDisplayCallback;
import lu.nowina.nexu.api.NewKeystore;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.Product;
import lu.nowina.nexu.api.ProductAdapter;
import lu.nowina.nexu.api.SystrayMenuItem;
import lu.nowina.nexu.api.flow.FutureOperationInvocation;
import lu.nowina.nexu.api.flow.NoOpFutureOperationInvocation;
import lu.nowina.nexu.keystore.KeystoreDatabase;
import lu.nowina.nexu.view.core.NonBlockingUIOperation;
import lu.nowina.nexu.view.core.UIOperation;

public class KeystoreProductAdapter
implements ProductAdapter {
    private final File nexuHome;

    public KeystoreProductAdapter(File nexuHome) {
        this.nexuHome = nexuHome;
    }

    @Override
    public boolean accept(Product product) {
        return product instanceof ConfiguredKeystore || product instanceof NewKeystore;
    }

    @Override
    public String getLabel(NexuAPI api, Product product, PasswordInputCallback callback) {
        return product.getLabel();
    }

    @Override
    public String getLabel(NexuAPI api, Product product, PasswordInputCallback callback, MessageDisplayCallback messageCallback) {
        throw new IllegalStateException("This product adapter does not support message display callback.");
    }

    @Override
    public boolean supportMessageDisplayCallback(Product product) {
        return false;
    }

    @Override
    public SignatureTokenConnection connect(NexuAPI api, Product product, PasswordInputCallback callback) {
        if (product instanceof NewKeystore) {
            throw new IllegalArgumentException("Given product was not configured!");
        }
        ConfiguredKeystore configuredKeystore = (ConfiguredKeystore)product;
        return new KeystoreTokenProxy(configuredKeystore, callback);
    }

    @Override
    public SignatureTokenConnection connect(NexuAPI api, Product product, PasswordInputCallback callback, MessageDisplayCallback messageCallback) {
        throw new IllegalStateException("This product adapter does not support message display callback.");
    }

    @Override
    public boolean canReturnIdentityInfo(Product product) {
        return false;
    }

    @Override
    public GetIdentityInfoResponse getIdentityInfo(SignatureTokenConnection token) {
        throw new IllegalStateException("This product adapter cannot return identity information.");
    }

    @Override
    public boolean supportCertificateFilter(Product product) {
        return false;
    }

    @Override
    public List<DSSPrivateKeyEntry> getKeys(SignatureTokenConnection token, CertificateFilter certificateFilter) {
        throw new IllegalStateException("This product adapter does not support certificate filter.");
    }

    @Override
    public boolean canReturnSuportedDigestAlgorithms(Product product) {
        return false;
    }

    @Override
    public List<DigestAlgorithm> getSupportedDigestAlgorithms(Product product) {
        throw new IllegalStateException("This product adapter cannot return list of supported digest algorithms.");
    }

    @Override
    public DigestAlgorithm getPreferredDigestAlgorithm(Product product) {
        throw new IllegalStateException("This product adapter cannot return list of supported digest algorithms.");
    }

    @Override
    public FutureOperationInvocation<Product> getConfigurationOperation(NexuAPI api, Product product) {
        if (product instanceof NewKeystore) {
            return UIOperation.getFutureOperationInvocation(UIOperation.class, "/fxml/configure-keystore.fxml", api.getAppConfig().getApplicationName());
        }
        return new NoOpFutureOperationInvocation<Product>(product);
    }

    @Override
    public FutureOperationInvocation<Boolean> getSaveOperation(NexuAPI api, Product product) {
        if (product instanceof NewKeystore) {
            throw new IllegalArgumentException("Given product was not configured!");
        }
        ConfiguredKeystore keystore = (ConfiguredKeystore)product;
        if (keystore.isToBeSaved()) {
            return UIOperation.getFutureOperationInvocation(UIOperation.class, "/fxml/save-keystore.fxml", api.getAppConfig().getApplicationName(), this, keystore);
        }
        return new NoOpFutureOperationInvocation<Boolean>(true);
    }

    @Override
    public SystrayMenuItem getExtensionSystrayMenuItem() {
        return new SystrayMenuItem(){

            @Override
            public String getLabel() {
                return ResourceBundle.getBundle("bundles/nexu").getString("systray.menu.manage.keystores");
            }

            @Override
            public FutureOperationInvocation<Void> getFutureOperationInvocation() {
                return UIOperation.getFutureOperationInvocation(NonBlockingUIOperation.class, "/fxml/manage-keystores.fxml", KeystoreProductAdapter.this.getDatabase());
            }
        };
    }

    public List<Product> detectProducts() {
        ArrayList<Product> products = new ArrayList<Product>();
        products.addAll(this.getDatabase().getKeystores());
        products.add(new NewKeystore());
        return products;
    }

    private KeystoreDatabase getDatabase() {
        return ProductDatabaseLoader.load(KeystoreDatabase.class, new File(this.nexuHome, "keystore-database.xml"));
    }

    public void saveKeystore(ConfiguredKeystore keystore) {
        this.getDatabase().add(keystore);
    }

    private static class KeystoreTokenProxy
    implements SignatureTokenConnection {
        private SignatureTokenConnection proxied;
        private final ConfiguredKeystore configuredKeystore;
        private final PasswordInputCallback callback;

        public KeystoreTokenProxy(ConfiguredKeystore configuredKeystore, PasswordInputCallback callback) {
            this.configuredKeystore = configuredKeystore;
            this.callback = callback;
        }

        private void initSignatureTokenConnection() {
            if (this.proxied != null) {
                return;
            }
            try {
                switch (this.configuredKeystore.getType()) {
                    case PKCS12: {
                        this.proxied = new Pkcs12SignatureToken(new URL(this.configuredKeystore.getUrl()).openStream(), new KeyStore.PasswordProtection(this.callback.getPassword()));
                        break;
                    }
                    case JKS: {
                        this.proxied = new JKSSignatureToken(new URL(this.configuredKeystore.getUrl()).openStream(), new KeyStore.PasswordProtection(this.callback.getPassword()));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled keystore type: " + (Object)((Object)this.configuredKeystore.getType()));
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new NexuException(e);
            }
            catch (IOException e) {
                throw new NexuException(e);
            }
        }

        @Override
        public void close() {
            SignatureTokenConnection stc = this.proxied;
            this.proxied = null;
            if (stc != null) {
                stc.close();
            }
        }

        @Override
        public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
            this.initSignatureTokenConnection();
            return this.proxied.getKeys();
        }

        @Override
        public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, DSSPrivateKeyEntry keyEntry) throws DSSException {
            this.initSignatureTokenConnection();
            return this.proxied.sign(toBeSigned, digestAlgorithm, keyEntry);
        }

        @Override
        public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, MaskGenerationFunction mgf, DSSPrivateKeyEntry keyEntry) throws DSSException {
            this.initSignatureTokenConnection();
            return this.proxied.sign(toBeSigned, digestAlgorithm, mgf, keyEntry);
        }
    }
}

