/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.jetty;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyListAwareServerConnector
extends ServerConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyListAwareServerConnector.class);
    private List<Integer> ports;
    private int currentPort;

    public JettyListAwareServerConnector(Server server) {
        super(server);
    }

    public JettyListAwareServerConnector(Server server, ConnectionFactory ... factories) {
        super(server, factories);
    }

    @Override
    public int getPort() {
        return this.currentPort;
    }

    @Override
    public void setPort(int port) {
        throw new IllegalStateException("This implementation only supports setPorts(List<Integer>).");
    }

    public void setPorts(List<Integer> ports) {
        if (this.isOpen()) {
            throw new IllegalStateException("Connector is already opened.");
        }
        if (ports == null || ports.isEmpty()) {
            throw new IllegalArgumentException("List of ports cannot be null or empty.");
        }
        for (int port : ports) {
            if (port >= 0 && port <= 65535) continue;
            throw new IllegalArgumentException("Port out of range:" + port);
        }
        this.ports = ports;
        this.currentPort = ports.get(0);
    }

    @Override
    public void open() throws IOException {
        for (int this.currentPort : this.ports) {
            try {
                super.open();
                LOGGER.info("Bound on port " + this.currentPort);
                return;
            }
            catch (IOException e) {
                LOGGER.warn("IOException (" + e.getMessage() + ") when trying to bind on port " + this.currentPort + ", will try next port.");
            }
        }
        throw new IOException("Cannot bind a free port in list " + this.toString(this.ports) + ".");
    }

    private String toString(List<Integer> ports) {
        StringBuilder sb = new StringBuilder("(");
        Iterator<Integer> it = ports.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

