/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.flow.operation;

import java.util.ArrayList;
import java.util.List;
import lu.nowina.nexu.api.Match;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.Product;
import lu.nowina.nexu.api.flow.OperationResult;
import lu.nowina.nexu.flow.operation.AbstractCompositeOperation;
import lu.nowina.nexu.flow.operation.CoreOperationStatus;

public class GetMatchingProductAdaptersOperation
extends AbstractCompositeOperation<List<Match>> {
    private List<Product> products;
    private NexuAPI api;

    @Override
    public void setParams(Object ... params) {
        try {
            this.products = (List)params[0];
            this.api = (NexuAPI)params[1];
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
            throw new IllegalArgumentException("Expected parameters: list of Product, NexuAPI");
        }
    }

    @Override
    public OperationResult<List<Match>> perform() {
        if (this.products.size() == 0) {
            return new OperationResult<List<Match>>(CoreOperationStatus.NO_PRODUCT_FOUND);
        }
        return this.getMatchingCardAdapters(this.products);
    }

    private OperationResult<List<Match>> getMatchingCardAdapters(List<Product> products) {
        ArrayList<Match> matchingCardAdapters = new ArrayList<Match>();
        for (Product p : products) {
            matchingCardAdapters.addAll(this.api.matchingProductAdapters(p));
        }
        return new OperationResult<List<Match>>(matchingCardAdapters);
    }
}

