/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.flow.operation;

import java.util.ArrayList;
import java.util.List;
import lu.nowina.nexu.api.Match;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.Product;
import lu.nowina.nexu.api.ProductAdapter;
import lu.nowina.nexu.api.flow.BasicOperationStatus;
import lu.nowina.nexu.api.flow.FutureOperationInvocation;
import lu.nowina.nexu.api.flow.OperationResult;
import lu.nowina.nexu.flow.operation.AbstractCompositeOperation;

public class ConfigureProductOperation
extends AbstractCompositeOperation<List<Match>> {
    private List<Match> matches;
    private NexuAPI api;

    @Override
    public void setParams(Object ... params) {
        try {
            this.matches = (List)params[0];
            this.api = (NexuAPI)params[1];
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
            throw new IllegalArgumentException("Expected parameters: list of Match, NexuAPI");
        }
    }

    @Override
    public OperationResult<List<Match>> perform() {
        ArrayList<Match> result = new ArrayList<Match>(this.matches.size());
        for (Match match : this.matches) {
            OperationResult<Product> op = this.handleMatch(match.getAdapter(), match.getProduct());
            if (op.getStatus().equals(BasicOperationStatus.SUCCESS)) {
                result.add(new Match(match.getAdapter(), op.getResult()));
                continue;
            }
            if (op.getStatus().equals(BasicOperationStatus.EXCEPTION)) {
                return new OperationResult<List<Match>>(op.getException());
            }
            return new OperationResult<List<Match>>(op.getStatus());
        }
        return new OperationResult<List<Match>>(result);
    }

    private OperationResult<Product> handleMatch(ProductAdapter productAdapter, Product product) {
        FutureOperationInvocation<Product> futureOperationInvocation = productAdapter.getConfigurationOperation(this.api, product);
        return futureOperationInvocation.call(this.operationFactory);
    }
}

