/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.api;

import com.sun.jna.platform.win32.Shell32Util;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    public static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationManager.class);

    public File manageConfiguration(String applicationName) throws IOException {
        String os = this.getOs();
        if (os != null && os.toLowerCase().contains("windows")) {
            return this.manageWindowsConfiguration(applicationName);
        }
        return this.manageCommonConfiguration(applicationName);
    }

    File manageCommonConfiguration(String appName) {
        File file = this.getCommonConfigPath(appName).toFile();
        if (file.exists()) {
            return file.canWrite() ? file : null;
        }
        return file.mkdirs() && file.canWrite() ? file : null;
    }

    File manageWindowsConfiguration(String appName) throws IOException {
        File windowsConfFolder = this.createWindowsConfigurationFolder(appName);
        File incorrectConfigFile = this.findExistingConfigFolder(appName);
        if (incorrectConfigFile.exists()) {
            this.moveExistingConfigFolder(incorrectConfigFile, windowsConfFolder);
        }
        return windowsConfFolder;
    }

    File createWindowsConfigurationFolder(String appName) {
        String appDataPath = this.getWindowsAppDataPath();
        if (StringUtils.isBlank(appDataPath)) {
            return null;
        }
        File windowsConfigFolder = Paths.get(this.getWindowsConfigPath().toString(), appName).toFile();
        if (windowsConfigFolder.exists()) {
            return windowsConfigFolder.canWrite() ? windowsConfigFolder : null;
        }
        return windowsConfigFolder.mkdirs() && windowsConfigFolder.canWrite() ? windowsConfigFolder : null;
    }

    File findExistingConfigFolder(String appName) {
        File oldConfigFolder = this.getCommonConfigPath(appName).toFile();
        if (oldConfigFolder == null) {
            return null;
        }
        if (oldConfigFolder.exists() && oldConfigFolder.list().length == 0) {
            oldConfigFolder.delete();
            return null;
        }
        return oldConfigFolder;
    }

    File moveExistingConfigFolder(File existingConfigFolder, File windowsConfigFolder) throws IOException {
        for (File configFile : existingConfigFolder.listFiles()) {
            try {
                Files.copy(configFile.toPath(), Paths.get(windowsConfigFolder.getAbsolutePath(), configFile.getName()), new CopyOption[0]);
            }
            catch (FileAlreadyExistsException faee) {
                LOGGER.debug("File {} already exists, we don't replace it.", (Object)configFile.getAbsolutePath());
            }
        }
        File backupFolder = Paths.get(this.getConfigBackupPath(existingConfigFolder).toString(), new String[0]).toFile();
        existingConfigFolder.renameTo(backupFolder);
        return backupFolder;
    }

    String getUserHome() {
        return System.getProperty("user.home");
    }

    String getWindowsAppDataPath() {
        if (this.getOs().toLowerCase().contains("windows")) {
            return Shell32Util.getFolderPath(28);
        }
        return "";
    }

    String getOs() {
        return System.getProperty("os.name");
    }

    String getCompanyName() {
        return "Nowina";
    }

    Path getCommonConfigPath(String appName) {
        return Paths.get(this.getUserHome(), "." + appName);
    }

    Path getWindowsConfigPath() {
        return Paths.get(this.getWindowsAppDataPath(), this.getCompanyName());
    }

    Path getConfigBackupPath(File originalFile) {
        return Paths.get(originalFile.getAbsolutePath() + ".BKP", new String[0]);
    }
}

