/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class UserPreferences {
    private static final String USE_SYSTEM_PROXY = "nowina.nexu.useSystemProxy";
    private static final String PROXY_SERVER = "nowina.nexu.proxyServer";
    private static final String PROXY_PORT = "nowina.nexu.proxyPort";
    private static final String PROXY_AUTHENTICATION = "nowina.nexu.proxyAuthentication";
    private static final String PROXY_USERNAME = "nowina.nexu.proxyUsername";
    private static final String PROXY_PASSWORD = "nowina.nexu.proxyPassword";
    private static final String PROXY_USE_HTTPS = "nowina.nexu.proxyHttps";
    private final Preferences prefs;
    private Boolean useSystemProxy;
    private String proxyServer;
    private Integer proxyPort;
    private Boolean proxyUseHttps;
    private Boolean proxyAuthentication;
    private String proxyUsername;
    private String proxyPassword;

    public UserPreferences(String applicationName) {
        this.prefs = Preferences.userRoot().node(applicationName);
        String useSystemProxyStr = this.prefs.get(USE_SYSTEM_PROXY, null);
        this.useSystemProxy = useSystemProxyStr != null ? Boolean.valueOf(useSystemProxyStr) : null;
        this.proxyServer = this.prefs.get(PROXY_SERVER, null);
        String proxyPortStr = this.prefs.get(PROXY_PORT, null);
        this.proxyPort = proxyPortStr != null ? Integer.valueOf(proxyPortStr) : null;
        String proxyHttps = this.prefs.get(PROXY_USE_HTTPS, null);
        this.proxyUseHttps = proxyHttps != null ? Boolean.valueOf(proxyHttps) : null;
        String proxyAuthenticationStr = this.prefs.get(PROXY_AUTHENTICATION, null);
        this.proxyAuthentication = proxyAuthenticationStr != null ? Boolean.valueOf(proxyAuthenticationStr) : null;
        this.proxyUsername = this.prefs.get(PROXY_USERNAME, null);
        this.proxyPassword = this.prefs.get(PROXY_PASSWORD, null);
    }

    public void setUseSystemProxy(Boolean useSystemProxy) {
        if (useSystemProxy != null) {
            this.prefs.putBoolean(USE_SYSTEM_PROXY, useSystemProxy);
        } else {
            this.prefs.remove(USE_SYSTEM_PROXY);
        }
        this.useSystemProxy = useSystemProxy;
    }

    public void setProxyServer(String proxyServer) {
        if (proxyServer != null) {
            this.prefs.put(PROXY_SERVER, proxyServer);
        } else {
            this.prefs.remove(PROXY_SERVER);
        }
        this.proxyServer = proxyServer;
    }

    public void setProxyPort(Integer proxyPort) {
        if (proxyPort != null) {
            this.prefs.putInt(PROXY_PORT, proxyPort);
        } else {
            this.prefs.remove(PROXY_PORT);
        }
        this.proxyPort = proxyPort;
    }

    public void setProxyUseHttps(Boolean proxyUseHttps) {
        if (proxyUseHttps != null) {
            this.prefs.putBoolean(PROXY_USE_HTTPS, proxyUseHttps);
        } else {
            this.prefs.remove(PROXY_USE_HTTPS);
        }
        this.proxyUseHttps = proxyUseHttps;
    }

    public void setProxyAuthentication(Boolean proxyAuthentication) {
        if (proxyAuthentication != null) {
            this.prefs.putBoolean(PROXY_AUTHENTICATION, proxyAuthentication);
        } else {
            this.prefs.remove(PROXY_AUTHENTICATION);
        }
        this.proxyAuthentication = proxyAuthentication;
    }

    public void setProxyUsername(String proxyUsername) {
        if (proxyUsername != null) {
            this.prefs.put(PROXY_USERNAME, proxyUsername);
        } else {
            this.prefs.remove(PROXY_USERNAME);
        }
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        if (proxyPassword != null) {
            this.prefs.put(PROXY_PASSWORD, proxyPassword);
        } else {
            this.prefs.remove(PROXY_PASSWORD);
        }
        this.proxyPassword = proxyPassword;
    }

    public Boolean isUseSystemProxy() {
        return this.useSystemProxy;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public Boolean isProxyUseHttps() {
        return this.proxyUseHttps;
    }

    public Boolean isProxyAuthentication() {
        return this.proxyAuthentication;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void clear() {
        try {
            this.prefs.clear();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(e);
        }
        this.useSystemProxy = null;
        this.proxyUseHttps = null;
        this.proxyServer = null;
        this.proxyPort = null;
        this.proxyAuthentication = null;
        this.proxyUsername = null;
        this.proxyPassword = null;
    }
}

