/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.stage.Stage;
import lu.nowina.nexu.APIBuilder;
import lu.nowina.nexu.HttpServer;
import lu.nowina.nexu.NexUPreLoader;
import lu.nowina.nexu.NexuLauncher;
import lu.nowina.nexu.ProductDatabaseLoader;
import lu.nowina.nexu.StandaloneUIDisplay;
import lu.nowina.nexu.SystrayMenu;
import lu.nowina.nexu.UserPreferences;
import lu.nowina.nexu.api.AppConfig;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.flow.OperationFactory;
import lu.nowina.nexu.api.plugin.InitializationMessage;
import lu.nowina.nexu.flow.BasicFlowRegistry;
import lu.nowina.nexu.flow.FlowRegistry;
import lu.nowina.nexu.flow.operation.BasicOperationFactory;
import lu.nowina.nexu.generic.SCDatabase;
import lu.nowina.nexu.view.core.UIDisplay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexUApp
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(NexUApp.class.getName());
    private HttpServer server;

    private AppConfig getConfig() {
        return NexuLauncher.getConfig();
    }

    private Properties getProperties() {
        return NexuLauncher.getProperties();
    }

    public void start(Stage primaryStage) throws Exception {
        Platform.setImplicitExit((boolean)false);
        StandaloneUIDisplay uiDisplay = new StandaloneUIDisplay();
        BasicOperationFactory operationFactory = new BasicOperationFactory();
        operationFactory.setDisplay(uiDisplay);
        uiDisplay.setOperationFactory(operationFactory);
        NexuAPI api = this.buildAPI(uiDisplay, operationFactory);
        logger.info("Start Jetty");
        this.server = this.startHttpServer(api);
        if (api.getAppConfig().isEnableSystrayMenu()) {
            new SystrayMenu(operationFactory, api, new UserPreferences(this.getConfig().getApplicationName()));
        } else {
            logger.info("Systray menu is disabled.");
        }
        logger.info("Start finished");
    }

    private NexuAPI buildAPI(UIDisplay uiDisplay, OperationFactory operationFactory) throws IOException {
        File nexuHome = this.getConfig().getNexuHome();
        SCDatabase db = null;
        if (nexuHome != null) {
            File store = new File(nexuHome, "store.xml");
            logger.info("Load database from " + store.getAbsolutePath());
            db = ProductDatabaseLoader.load(SCDatabase.class, store);
        } else {
            db = new SCDatabase();
        }
        APIBuilder builder = new APIBuilder();
        NexuAPI api = builder.build(uiDisplay, this.getConfig(), this.getFlowRegistry(), db, operationFactory);
        this.notifyPreloader(builder.initPlugins(api, this.getProperties()));
        return api;
    }

    protected FlowRegistry getFlowRegistry() {
        return new BasicFlowRegistry();
    }

    private HttpServer startHttpServer(NexuAPI api) throws Exception {
        HttpServer server = this.buildHttpServer();
        server.setConfig(api);
        try {
            server.start();
        }
        catch (Exception e) {
            try {
                server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        return server;
    }

    private HttpServer buildHttpServer() {
        try {
            Class<?> cla = Class.forName(this.getConfig().getHttpServerClass());
            logger.info("HttpServer is " + this.getConfig().getHttpServerClass());
            HttpServer server = (HttpServer)cla.newInstance();
            return server;
        }
        catch (Exception e) {
            logger.error("Cannot instanciate Http Server " + this.getConfig().getHttpServerClass(), e);
            throw new RuntimeException("Cannot instanciate Http Server");
        }
    }

    public void stop() throws Exception {
        logger.info("Stopping application...");
        try {
            if (this.server != null) {
                this.server.stop();
                this.server = null;
            }
        }
        catch (Exception e) {
            logger.error("Cannot stop server", e);
        }
    }

    private void notifyPreloader(List<InitializationMessage> messages) {
        for (InitializationMessage message : messages) {
            Alert.AlertType alertType;
            switch (message.getMessageType()) {
                case WARNING: {
                    alertType = Alert.AlertType.WARNING;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message type: " + (Object)((Object)message.getMessageType()));
                }
            }
            NexUPreLoader.PreloaderMessage preloaderMessage = new NexUPreLoader.PreloaderMessage(alertType, message.getTitle(), message.getHeaderText(), message.getContentText());
            this.notifyPreloader(preloaderMessage);
        }
    }
}

