/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import lu.nowina.nexu.CardDetector;
import lu.nowina.nexu.InternalAPI;
import lu.nowina.nexu.NexuException;
import lu.nowina.nexu.api.AppConfig;
import lu.nowina.nexu.api.EnvironmentInfo;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.flow.OperationFactory;
import lu.nowina.nexu.api.plugin.HttpPlugin;
import lu.nowina.nexu.api.plugin.InitializationMessage;
import lu.nowina.nexu.api.plugin.NexuPlugin;
import lu.nowina.nexu.flow.FlowRegistry;
import lu.nowina.nexu.generic.SCDatabase;
import lu.nowina.nexu.view.core.UIDisplay;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIBuilder.class.getName());

    public NexuAPI build(UIDisplay display, AppConfig appConfig, FlowRegistry flowRegistry, SCDatabase localDatabase, OperationFactory operationFactory) {
        CardDetector detector = new CardDetector(EnvironmentInfo.buildFromSystemProperties(System.getProperties()));
        return new InternalAPI(display, localDatabase, detector, flowRegistry, operationFactory, appConfig);
    }

    public List<InitializationMessage> initPlugins(NexuAPI api, Properties properties) {
        ArrayList<InitializationMessage> messages = new ArrayList<InitializationMessage>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("plugin_")) continue;
            String pluginClassName = properties.getProperty(key);
            String pluginId = key.substring("plugin_".length());
            LOGGER.info(" + Plugin " + pluginClassName);
            messages.addAll(this.buildAndRegisterPlugin((InternalAPI)api, pluginClassName, pluginId));
        }
        return messages;
    }

    private List<InitializationMessage> buildAndRegisterPlugin(InternalAPI api, String pluginClassName, String pluginId) {
        try {
            Class<NexuPlugin> clazz = Class.forName(pluginClassName).asSubclass(NexuPlugin.class);
            NexuPlugin plugin = clazz.newInstance();
            List<InitializationMessage> messages = plugin.init(pluginId, api);
            for (Object o : ClassUtils.getAllInterfaces(clazz)) {
                this.registerPlugin(api, pluginId, (Class)o, plugin);
            }
            return messages;
        }
        catch (Exception e) {
            LOGGER.error(MessageFormat.format("Cannot register plugin {0} (id: {1})", pluginClassName, pluginId), e);
            throw new NexuException(e);
        }
    }

    private void registerPlugin(InternalAPI api, String pluginId, Class<?> i, Object plugin) {
        if (HttpPlugin.class.equals(i)) {
            HttpPlugin p = (HttpPlugin)plugin;
            api.registerHttpContext(pluginId, p);
        }
    }
}

