/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.x509;

import iaik.me.asn1.ASN1;
import iaik.me.utils.Util;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class X509Extension {
    private Object[] a;
    private boolean d;
    private int c;
    private String b;
    private static final String[] e = new String[]{"0", "10", "  01", "    0", "     0", "      012", "      012", "         0", "         0", "          0", "           0", "            0"};
    public static final int NSTYPE_OBJECT_SIGNING_CA = 256;
    public static final int NSTYPE_SMIME_CA = 512;
    public static final int NSTYPE_SSL_CA = 1024;
    public static final int NSTYPE_OBJECT_SIGNING = 4096;
    public static final int NSTYPE_SMIME = 8192;
    public static final int NSTYPE_SSL_SERVER = 16384;
    public static final int NSTYPE_SSL_CLIENT = 32768;
    public static final int KU_DECIPHER_ONLY = 128;
    public static final int KU_ENCIPHER_ONLY = 256;
    public static final int KU_CRL_SIGN = 512;
    public static final int KU_KEY_CERT_SIGN = 1024;
    public static final int KU_KEY_AGREEMENT = 2048;
    public static final int KU_DATA_ENCIPHERMENT = 4096;
    public static final int KU_KEY_ENCIPHERMENT = 8192;
    public static final int KU_NON_REPUDIATION = 16384;
    public static final int KU_DIGITAL_SIGNATURE = 32768;
    public static final int X_NS_SERVER_NAME = 12;
    public static final int X_NS_COMMENT = 11;
    public static final int X_NS_CERT_TYPE = 10;
    public static final int X_KEY_ID = 9;
    public static final int X_ALT_NAME_URI = 8;
    public static final int X_ALT_NAME_DNS = 7;
    public static final int X_ALT_NAME_EMAIL = 6;
    public static final int X_EXT_KEY_USAGE = 5;
    public static final int X_KEY_USAGE = 4;
    public static final int X_BC_LENGTH = 3;
    public static final int X_BC_IS_CA = 2;
    public static final int X_ORIGINAL_OID = 1;
    public static final int X_ENCODING = 0;
    private static final int k = 11;
    private static final int l = 10;
    private static final int m = 9;
    private static final int s = 8;
    private static final int i = 7;
    private static final int o = 6;
    private static final int j = 5;
    private static final int p = 4;
    private static final int n = 3;
    private static final int r = 2;
    private static final int q = 1;
    private static final int h = 0;
    public static final String OID_EKU_TIME_STAMPING = "1.3.6.1.5.5.7.3.8";
    public static final String OID_EKU_EMAIL_PROTECTION = "1.3.6.1.5.5.7.3.4";
    public static final String OID_EKU_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    public static final String OID_EKU_CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";
    public static final String OID_EKU_SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    private static final String f = "2.5.29.36";
    private static final String g = "2.5.29.31";
    public static final String OID_NETSCAPE_SSL_SERVER_NAME = "2.16.840.1.113730.1.12";
    public static final String OID_NETSCAPE_COMMENT = "2.16.840.1.113730.1.13";
    public static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    public static final String OID_QCSTATEMENTS = "1.3.6.1.5.5.7.1.3";
    public static final String OID_CERTIFICATE_POLICIES = "2.5.29.32";
    public static final String OID_AUTHORITY_KEY_IDENTIFIER = "2.5.29.35";
    public static final String OID_SUBJECT_KEY_IDENTIFIER = "2.5.29.14";
    public static final String OID_ISSUER_ALT_NAME = "2.5.29.18";
    public static final String OID_SUBJECT_ALT_NAME = "2.5.29.17";
    public static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    public static final String OID_KEY_USAGE = "2.5.29.15";
    public static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    public static final String OID_ERROR = "0.0.0";

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Extension " + ASN1.getName(this.b) + " (" + this.b + ") " + (this.d ? "CRITICAL" : "non critical") + ":\r\n");
        int n = 0;
        while (n < this.a.length) {
            Object object = this.a[n];
            if (object instanceof byte[]) {
                stringBuffer.append(Util.toString((byte[])object));
                stringBuffer.append("\r\n");
            } else if (object instanceof Vector) {
                Enumeration enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    X509Extension.a(stringBuffer, enumeration.nextElement());
                    stringBuffer.append("\r\n");
                }
            } else {
                X509Extension.a(stringBuffer, object);
                stringBuffer.append("\r\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void a(int n, Object object) {
        this.a[this.a((int)n)] = object;
    }

    private void a(byte[] byArray) throws IOException {
        block0 : switch (this.c) {
            case 2: {
                ASN1 aSN1 = new ASN1(byArray);
                boolean bl = false;
                int n = -1;
                switch (aSN1.getSize()) {
                    case 2: {
                        n = aSN1.getElementAt(1).gvInt();
                    }
                    case 1: {
                        bl = aSN1.getElementAt(0).gvBoolean();
                        break;
                    }
                }
                this.a(2, bl ? new Boolean(true) : new Boolean(false));
                this.a(3, new Integer(n));
                break;
            }
            case 3: {
                ASN1 aSN1 = new ASN1(byArray);
                byte[] byArray2 = aSN1.gvByteArray();
                int n = 0;
                if (byArray2.length >= 1) {
                    n = (byArray2[0] & 0xFF) << 8;
                    if (byArray2.length >= 2) {
                        n |= byArray2[1] & 0xFF;
                    }
                }
                this.a(4, new Integer(n));
                break;
            }
            case 4: {
                ASN1 aSN1 = new ASN1(byArray);
                Vector<String> vector = new Vector<String>();
                Enumeration enumeration = aSN1.gvVector().elements();
                while (enumeration.hasMoreElements()) {
                    ASN1 aSN12 = (ASN1)enumeration.nextElement();
                    vector.addElement(aSN12.gvString());
                }
                this.a(5, vector);
                break;
            }
            case 5: 
            case 6: {
                ASN1 aSN1 = new ASN1(byArray, 0, true);
                Enumeration enumeration = aSN1.gvVector().elements();
                while (enumeration.hasMoreElements()) {
                    ASN1 aSN13 = (ASN1)enumeration.nextElement();
                    int n = aSN13.getTypeOnly();
                    switch (n) {
                        case 1: 
                        case 2: 
                        case 6: {
                            aSN13.setImplicitTag(22);
                            String string = aSN13.gvASN1().gvString();
                            int n2 = n == 1 ? 6 : (n == 2 ? 7 : 8);
                            this.a(n2, string);
                            break;
                        }
                    }
                }
                break;
            }
            case 7: {
                ASN1 aSN1 = new ASN1(byArray);
                byte[] byArray3 = aSN1.gvByteArray();
                this.a(9, byArray3);
                break;
            }
            case 8: {
                ASN1 aSN1 = new ASN1(byArray, 0, true);
                Enumeration enumeration = aSN1.gvVector().elements();
                while (enumeration.hasMoreElements()) {
                    ASN1 aSN14 = (ASN1)enumeration.nextElement();
                    if (aSN14.getType() != Integer.MIN_VALUE) continue;
                    aSN14.setImplicitTag(4);
                    byte[] byArray4 = aSN14.gvASN1().gvByteArray();
                    this.a(9, byArray4);
                    break block0;
                }
                break;
            }
            case 9: {
                ASN1 aSN1 = new ASN1(byArray);
                byte[] byArray5 = aSN1.gvByteArray();
                int n = 0;
                if (byArray5.length >= 1) {
                    n = (byArray5[0] & 0xFF) << 8;
                    if (byArray5.length >= 2) {
                        n |= byArray5[1] & 0xFF;
                    }
                }
                this.a(10, new Integer(n));
                break;
            }
            case 10: 
            case 11: {
                ASN1 aSN1 = new ASN1(byArray);
                String string = aSN1.gvString();
                this.a(this.c == 10 ? 11 : 12, string);
                break;
            }
            default: {
                this.a(0, byArray);
            }
        }
    }

    public boolean isCritical() {
        return this.d;
    }

    private void a() {
        this.c = this.b.equals(OID_BASIC_CONSTRAINTS) ? 2 : (this.b.equals(OID_KEY_USAGE) ? 3 : (this.b.equals(OID_EXTENDED_KEY_USAGE) ? 4 : (this.b.equals(OID_SUBJECT_ALT_NAME) ? 5 : (this.b.equals(OID_ISSUER_ALT_NAME) ? 6 : (this.b.equals(OID_SUBJECT_KEY_IDENTIFIER) ? 7 : (this.b.equals(OID_AUTHORITY_KEY_IDENTIFIER) ? 8 : (this.b.equals(OID_NETSCAPE_CERT_TYPE) ? 9 : (this.b.equals(OID_NETSCAPE_COMMENT) ? 10 : (this.b.equals(OID_NETSCAPE_SSL_SERVER_NAME) ? 11 : (this.b.equals(OID_ERROR) ? 1 : 0))))))))));
        String string = e[this.c];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.charAt(n2) - 48;
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        this.a = new Object[n + 1];
    }

    public Object getValue(int n) {
        return this.a[this.a(n)];
    }

    public String getString(int n) {
        return (String)this.getValue(n);
    }

    public String getObjectID() {
        return this.b;
    }

    public int getInteger(int n) {
        return (Integer)this.getValue(n);
    }

    private int a(int n) {
        String string = e[this.c];
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Invalid parameter " + n + " for extension " + this.b);
        }
        int n2 = string.charAt(n) - 48;
        if (n2 < 0 || n2 >= this.a.length) {
            throw new IndexOutOfBoundsException("Invalid parameter " + n + " for extension " + this.b);
        }
        return n2;
    }

    public Enumeration getEnumeration(int n) {
        return ((Vector)this.getValue(n)).elements();
    }

    public byte[] getByteArray(int n) {
        return (byte[])this.getValue(n);
    }

    public boolean getBoolean(int n) {
        return (Boolean)this.getValue(n);
    }

    private static void a(StringBuffer stringBuffer, Object object) {
        if (object instanceof String && ASN1.isObjectId((String)object)) {
            stringBuffer.append(ASN1.getName((String)object));
            stringBuffer.append(" (");
            stringBuffer.append(object);
            stringBuffer.append(")");
        } else {
            stringBuffer.append(object);
        }
    }

    public X509Extension(ASN1 aSN1) throws IOException {
        byte[] byArray;
        String string;
        this.b = string = aSN1.getElementAt(0).gvString();
        this.d = false;
        if (aSN1.getElementAt(1).getType() == 1) {
            this.d = aSN1.getElementAt(1).gvBoolean();
            byArray = aSN1.getElementAt(2).gvByteArray();
        } else {
            byArray = aSN1.getElementAt(1).gvByteArray();
        }
        this.a();
        try {
            this.a(byArray);
        }
        catch (IOException iOException) {
            this.b = OID_ERROR;
            this.a();
            this.a(1, string);
            this.a(0, byArray);
        }
    }

    static {
        ASN1.register(OID_ERROR, "Pseudo OID for invalid extensions");
        ASN1.register(OID_BASIC_CONSTRAINTS, "X.509v3 basic constraints");
        ASN1.register(OID_KEY_USAGE, "X.509v3 key usage");
        ASN1.register(OID_EXTENDED_KEY_USAGE, "X.509v3 extended key usage");
        ASN1.register(OID_SUBJECT_ALT_NAME, "X.509v3 subject alternate name");
        ASN1.register(OID_ISSUER_ALT_NAME, "X.509v3 issueralternate name");
        ASN1.register(OID_SUBJECT_KEY_IDENTIFIER, "X.509v3 subject key identifier");
        ASN1.register(OID_AUTHORITY_KEY_IDENTIFIER, "X.509v3 authority key identifier");
        ASN1.register(OID_NETSCAPE_CERT_TYPE, "X.509v3 Netscape certificate type");
        ASN1.register(OID_NETSCAPE_COMMENT, "X.509v3 Netscape comment");
        ASN1.register(OID_NETSCAPE_SSL_SERVER_NAME, "X.509v3 Netscape SSL server name");
        ASN1.register(OID_CERTIFICATE_POLICIES, "X.509v3 certificate policies");
        ASN1.register(g, "X.509v3 CRL distribution points");
        ASN1.register(f, "X.509v3 policy constraints");
        ASN1.register(OID_EKU_SERVER_AUTH, "ext. key usage: server authentication");
        ASN1.register(OID_EKU_CLIENT_AUTH, "ext. key usage: client authentication");
        ASN1.register(OID_EKU_CODE_SIGNING, "ext. key usage: code signing");
        ASN1.register(OID_EKU_EMAIL_PROTECTION, "ext. key usage: email protection");
        ASN1.register(OID_EKU_TIME_STAMPING, "ext. key usage: time stamping");
        ASN1.register(OID_QCSTATEMENTS, "X.509v3 QCStatements");
    }
}

