/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.security.rsa;

import iaik.me.security.BigInteger;
import iaik.me.security.CryptoBag;
import iaik.me.security.CryptoException;
import iaik.me.security.KeyPairGenerator;
import iaik.me.security.PrivateKey;
import iaik.me.security.PublicKey;
import iaik.me.security.SecureRandom;
import iaik.me.security.rsa.OAEPParams;
import iaik.me.utils.SysUtil;
import java.util.Random;

public class RSAKeyPairGenerator
extends KeyPairGenerator {
    private static final long g = 58642669L;
    private static final long h = 111546435L;
    private static final BigInteger f;
    private static BigInteger l;
    private static BigInteger k;
    private OAEPParams m;
    private SecureRandom a;
    private BigInteger b;
    private int c;
    private static final BigInteger i;
    private static final BigInteger e;
    private static final BigInteger j;
    private static final BigInteger d;

    private static BigInteger d(BigInteger bigInteger) {
        bigInteger = bigInteger.setBit(0);
        while (!RSAKeyPairGenerator.b(bigInteger)) {
            bigInteger = bigInteger.add(e);
        }
        return bigInteger;
    }

    private static boolean c(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        int n2 = n <= 500 ? (n <= 100 ? 27 : (n <= 150 ? 18 : (n <= 200 ? 15 : (n <= 250 ? 12 : (n <= 300 ? 9 : (n <= 350 ? 8 : (n <= 400 ? 7 : 6))))))) : (n <= 600 ? 5 : (n <= 800 ? 4 : (n <= 1250 ? 3 : 2)));
        BigInteger bigInteger2 = BigInteger.valueOf(1L);
        BigInteger bigInteger3 = BigInteger.valueOf(2L);
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger2);
        int n3 = bigInteger4.getLowestSetBit();
        BigInteger bigInteger5 = bigInteger4.shiftRight(n3);
        BigInteger bigInteger6 = bigInteger.subtract(BigInteger.valueOf(4L));
        byte[] byArray = new byte[20];
        Random random = new Random();
        SysUtil.nextBytes(random, byArray);
        SecureRandom secureRandom = SecureRandom.getDefault();
        secureRandom.setSeed(byArray);
        int n4 = 1;
        while (n4 <= n2) {
            BigInteger bigInteger7 = new BigInteger(n + 4, secureRandom);
            BigInteger bigInteger8 = (bigInteger7 = bigInteger7.mod(bigInteger6).add(bigInteger3)).modPow(bigInteger5, bigInteger);
            if (bigInteger8.compareTo(bigInteger2) != 0 && bigInteger8.compareTo(bigInteger4) != 0) {
                int n5 = 1;
                while (n5 <= n3 - 1 && (n5 == 1 || bigInteger8.compareTo(bigInteger4) != 0)) {
                    if ((bigInteger8 = bigInteger8.modPow(bigInteger3, bigInteger)).compareTo(bigInteger2) == 0) {
                        return false;
                    }
                    ++n5;
                }
                if (bigInteger8.compareTo(bigInteger4) != 0) {
                    return false;
                }
            }
            ++n4;
        }
        return true;
    }

    private static boolean b(BigInteger bigInteger) {
        if (bigInteger.compareTo(j) <= 0) {
            return false;
        }
        if (RSAKeyPairGenerator.a(bigInteger)) {
            return false;
        }
        return RSAKeyPairGenerator.c(bigInteger);
    }

    public void initialize(int n, Object object, SecureRandom secureRandom, Object object2) throws CryptoException {
        this.initialize(n, object, secureRandom);
        if (!(object2 instanceof OAEPParams)) {
            throw new CryptoException("No OAEP parameter provided!");
        }
        this.m = (OAEPParams)object2;
    }

    public void initialize(int n, Object object, SecureRandom secureRandom) throws CryptoException {
        this.c = n;
        this.a = secureRandom;
        if (object != null) {
            if (!(object instanceof BigInteger)) {
                throw new CryptoException("Parameter must be BigInteger (public exponent)!");
            }
            this.b = (BigInteger)object;
        }
    }

    private static boolean a(BigInteger bigInteger) {
        if (!bigInteger.testBit(0)) {
            return true;
        }
        long l = bigInteger.mod(f).longValue();
        int n = (int)(l % 111546435L);
        if (n % 3 == 0 || n % 5 == 0 || n % 7 == 0 || n % 11 == 0 || n % 13 == 0 || n % 17 == 0 || n % 19 == 0 || n % 23 == 0) {
            return true;
        }
        int n2 = (int)(l % 58642669L);
        return n2 % 29 == 0 || n2 % 31 == 0 || n2 % 37 == 0 || n2 % 41 == 0 || n2 % 43 == 0;
    }

    private static BigInteger a(int n, SecureRandom secureRandom) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3 = d.setBit(511 + 128 * n);
        BigInteger bigInteger4 = bigInteger3.multiply(k).divide(l);
        while ((bigInteger2 = new BigInteger(512 + 128 * n, secureRandom)).compareTo(bigInteger4) == -1) {
        }
        BigInteger bigInteger5 = RSAKeyPairGenerator.d(new BigInteger(101, secureRandom));
        BigInteger bigInteger6 = RSAKeyPairGenerator.d(new BigInteger(101, secureRandom));
        BigInteger bigInteger7 = bigInteger6.modInverse(bigInteger5).multiply(bigInteger6);
        BigInteger bigInteger8 = bigInteger7.compareTo(bigInteger = bigInteger5.modInverse(bigInteger6).multiply(bigInteger5)) >= 0 ? bigInteger7.subtract(bigInteger) : bigInteger.subtract(bigInteger7);
        BigInteger bigInteger9 = bigInteger5.multiply(bigInteger6);
        BigInteger bigInteger10 = bigInteger8.mod(bigInteger9).add(bigInteger9).subtract(bigInteger2.mod(bigInteger9)).mod(bigInteger9);
        BigInteger bigInteger11 = bigInteger2.add(bigInteger10);
        while (!RSAKeyPairGenerator.b(bigInteger11)) {
            bigInteger11 = bigInteger11.add(bigInteger9);
        }
        return bigInteger11;
    }

    public CryptoBag generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        if (this.a == null) {
            this.a = SecureRandom.getDefault();
        }
        BigInteger bigInteger7 = this.b;
        if (this.c < 512) {
            this.c = 512;
        }
        int n = this.c >= 1024 ? (this.c - 769) / 256 : (this.c - 1024) / 256;
        while (true) {
            if ((bigInteger6 = RSAKeyPairGenerator.a(n, this.a)).compareTo(bigInteger5 = RSAKeyPairGenerator.a(n, this.a)) < 0) {
                bigInteger4 = bigInteger6;
                bigInteger6 = bigInteger5;
                bigInteger5 = bigInteger4;
            }
            if (bigInteger6.subtract(bigInteger5).abs().bitLength() < 412 + 128 * n) continue;
            bigInteger3 = bigInteger6.subtract(j);
            bigInteger2 = bigInteger5.subtract(j);
            bigInteger = bigInteger3.multiply(bigInteger2);
            if (bigInteger7 == null) {
                bigInteger7 = i;
                while (bigInteger7.gcd(bigInteger).compareTo(j) != 0) {
                    bigInteger7 = bigInteger7.add(e);
                }
                break;
            }
            if (bigInteger7.gcd(bigInteger).compareTo(j) == 0) break;
        }
        bigInteger4 = bigInteger6.multiply(bigInteger5);
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger);
        BigInteger bigInteger9 = bigInteger8.mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger8.mod(bigInteger2);
        BigInteger bigInteger11 = bigInteger5.modInverse(bigInteger6);
        PublicKey publicKey = null;
        PrivateKey privateKey = null;
        if (this.getAlgorithm().equals("RSA")) {
            publicKey = PublicKey.makeRSAPublicKey(bigInteger4, bigInteger7);
            privateKey = PrivateKey.makeRSAPrivateKey(bigInteger4, bigInteger7, bigInteger8, bigInteger6, bigInteger5, bigInteger9, bigInteger10, bigInteger11);
        } else {
            if (this.m == null) {
                this.m = new OAEPParams();
            }
            publicKey = PublicKey.makeRSAOAEPPublicKey(bigInteger4, bigInteger7, this.m);
            privateKey = PrivateKey.makeRSAOAEPPrivateKey(bigInteger4, bigInteger7, bigInteger8, bigInteger6, bigInteger5, bigInteger9, bigInteger10, bigInteger11, this.m);
        }
        return CryptoBag.makeKeyPair(publicKey, privateKey);
    }

    static {
        d = BigInteger.valueOf(0L);
        j = BigInteger.valueOf(1L);
        e = BigInteger.valueOf(2L);
        i = BigInteger.valueOf(65537L);
        k = BigInteger.valueOf(142L);
        l = BigInteger.valueOf(100L);
        f = BigInteger.valueOf(6541380665835015L);
    }
}

