/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.security;

import iaik.me.asn1.ASN1;
import iaik.me.security.CryptoException;
import iaik.me.security.MessageDigest;
import iaik.me.security.PrivateKey;
import iaik.me.security.PublicKey;
import iaik.me.security.SecureRandom;
import iaik.me.utils.Util;
import java.util.Hashtable;

public abstract class Signature {
    private static final String d = "iaik.me.security.dsa.DSASignature";
    private static final String e = "iaik.me.security.rsa.RSAPssSignature";
    private static final String c = "iaik.me.security.rsa.RSASignature";
    protected Object params_;
    protected SecureRandom random;
    protected MessageDigest md;
    private String b;
    private static Hashtable a;

    public abstract boolean verify(byte[] var1) throws CryptoException;

    public void update(byte[] byArray, int n, int n2) throws CryptoException {
        this.md.update(byArray, n, n2);
    }

    public final void update(byte[] byArray) throws CryptoException {
        this.update(byArray, 0, byArray.length);
    }

    public abstract byte[] sign() throws CryptoException;

    public void setParams(Object object) {
        this.params_ = object;
    }

    public static void register(String string, String string2) {
        a.put(string, string2);
    }

    public abstract void initVerify(PublicKey var1) throws CryptoException;

    public abstract void initSign(PrivateKey var1, SecureRandom var2) throws CryptoException;

    private static void a() {
        a = new Hashtable(16);
        Signature.register("MD2withRSA", c);
        Signature.register("MD5withRSA", c);
        Signature.register("SHA1withRSA", c);
        Signature.register("SHA224withRSA", c);
        Signature.register("SHA256withRSA", c);
        Signature.register("RIPEMD160withRSA", c);
        Signature.register("SHA1withDSA", d);
        Signature.register("DSA", d);
        Signature.register("RawDSA", d);
        Signature.register("SHA1withRSAandMGF1", e);
        Signature.register("SHA1withRSAandMGF1", e);
        Signature.register("SHA224withRSAandMGF1", e);
        Signature.register("SHA256withRSAandMGF1", e);
        Signature.register("MD2withRSAandMGF1", e);
        Signature.register("MD5withRSAandMGF1", e);
        Signature.register("RSASSA-PSS", e);
    }

    public static Signature getInstance(String string) throws CryptoException {
        Class clazz = Util.loadClass((String)a.get(string = ASN1.getName(string)));
        if (clazz == null) {
            throw new CryptoException("Signature algorithm " + string + " not available!");
        }
        try {
            Signature signature = (Signature)clazz.newInstance();
            signature.b = string;
            return signature;
        }
        catch (Exception exception) {
            throw new CryptoException(exception.toString());
        }
    }

    public final String getAlgorithm() {
        return this.b;
    }

    protected Signature() {
    }

    static {
        Signature.a();
    }
}

