/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.keymgmt;

import iaik.me.asn1.ASN1;
import iaik.me.keymgmt.KeyAndCert;
import iaik.me.security.BigInteger;
import iaik.me.security.Cipher;
import iaik.me.security.CryptoException;
import iaik.me.security.Mac;
import iaik.me.security.PBE;
import iaik.me.security.PrivateKey;
import iaik.me.security.SecureRandom;
import iaik.me.utils.CryptoUtils;
import iaik.me.utils.SysUtil;
import iaik.me.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class KeyStore {
    private Hashtable b;
    private Hashtable c;
    private SecureRandom a = null;
    private Hashtable d = new Hashtable(16);
    private static final int g = 3;
    private static final int i = 2;
    private static final int f = 1;
    private static final int h = 0;
    private static final ASN1 k = new ASN1(2, BigInteger.ZERO);
    private static final String e = "1.3.6.1.4.1.2706.2.1";
    private static final boolean j = false;

    public byte[] store(char[] cArray, int n) throws CryptoException {
        Object object;
        X509Certificate[] x509CertificateArray;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Hashtable<Object, BigInteger> hashtable = new Hashtable<Object, BigInteger>(this.d.size() * 3);
        Hashtable hashtable2 = new Hashtable(this.d.size() * 2);
        int n2 = 1;
        Enumeration enumeration = this.aliases();
        while (enumeration.hasMoreElements()) {
            object8 = (String)enumeration.nextElement();
            object7 = this.getPrivateKey((String)object8);
            object6 = this.getCertificateChain((String)object8);
            if (object7 != null) {
                hashtable.put(object7, BigInteger.valueOf(n2++));
            }
            if (object6 == null) continue;
            int n3 = 0;
            while (n3 < ((X509Certificate[])object6).length) {
                hashtable.put(object6[n3], BigInteger.valueOf(n2++));
                ++n3;
            }
        }
        object8 = ASN1.makeSequence(hashtable.size() * 2 + 1);
        object7 = ASN1.makeSequence(this.d.size() * 2 + 1);
        ((ASN1)object8).addElement(KeyStore.a(0, BigInteger.ZERO, (ASN1)object7));
        object6 = hashtable.keys();
        while (object6.hasMoreElements()) {
            int n4;
            Object e = object6.nextElement();
            object5 = (BigInteger)hashtable.get(e);
            if (e instanceof X509Certificate) {
                n4 = 2;
                object4 = ((X509Certificate)e).getEncoded();
            } else {
                n4 = 1;
                object4 = ((PrivateKey)e).getEncoded();
            }
            ((ASN1)object8).addElement(KeyStore.a(n4, (BigInteger)object5, new ASN1(4, object4)));
        }
        Enumeration enumeration2 = this.aliases();
        while (enumeration2.hasMoreElements()) {
            object5 = (String)enumeration2.nextElement();
            object4 = this.d.get(object5);
            ASN1 aSN1 = ASN1.makeSequence(2);
            aSN1.addElement(new ASN1(12, object5));
            if (object4 instanceof PrivateKey) {
                aSN1.addElement(KeyStore.a(hashtable.get(object4)));
            } else {
                object3 = null;
                if (object4 instanceof KeyAndCert) {
                    object2 = (KeyAndCert)object4;
                    object3 = ((KeyAndCert)object2).getPrivateKey();
                    x509CertificateArray = ((KeyAndCert)object2).getCertificateChain();
                } else {
                    x509CertificateArray = (X509Certificate[])object4;
                }
                object2 = ASN1.makeSequence(2 * (x509CertificateArray.length + 1));
                if (object3 != null) {
                    ((ASN1)object2).addElement(KeyStore.a(hashtable.get(object3)));
                } else {
                    ((ASN1)object2).addElement(new ASN1(5, null));
                }
                int n5 = 0;
                while (n5 < x509CertificateArray.length) {
                    ((ASN1)object2).addElement(KeyStore.a(hashtable.get(x509CertificateArray[n5])));
                    ++n5;
                }
                object = BigInteger.valueOf(n2++);
                ((ASN1)object8).addElement(KeyStore.a(3, (BigInteger)object, (ASN1)object2));
                aSN1.addElement(KeyStore.a(object));
            }
            ((ASN1)object7).addElement(aSN1);
        }
        object5 = ((ASN1)object8).getEncoded();
        object4 = PBE.getInstance(null, 0, 0, -1, null);
        Cipher cipher = ((PBE)object4).getCipher(1, cArray, null, n, this.a);
        object3 = cipher.doFinal((byte[])object5);
        x509CertificateArray = ((PBE)object4).getASN1();
        object2 = ASN1.makeSequence(2);
        ((ASN1)object2).addElement((ASN1)x509CertificateArray);
        ((ASN1)object2).addElement(new ASN1(4, object3));
        ASN1 aSN1 = ASN1.makeSequence(3);
        aSN1.addElement(new ASN1(2, BigInteger.ZERO));
        aSN1.addElement(new ASN1(2, BigInteger.valueOf(n2)));
        aSN1.addElement(new ASN1(-2147483647, object2));
        object = ASN1.makeSequence(1);
        ((ASN1)object).addElement(aSN1);
        byte[] byArray = ((ASN1)object).getEncoded();
        PBE pBE = PBE.getInstance(null, 0, 0, 0, null);
        Mac mac = pBE.getMac(cArray, null, n, this.a);
        byte[] byArray2 = mac.doFinal(byArray);
        ASN1 aSN12 = pBE.getASN1();
        ASN1 aSN13 = ASN1.makeSequence(2);
        aSN13.addElement(aSN12);
        aSN13.addElement(new ASN1(4, byArray2));
        ASN1 aSN14 = ASN1.makeSequence(3);
        aSN14.addElement(new ASN1(6, e));
        aSN14.addElement(aSN13);
        aSN14.addElement(new ASN1(4, byArray));
        return aSN14.getEncoded();
    }

    public byte[] store(char[] cArray) throws CryptoException {
        return this.store(cArray, 2048);
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.a = secureRandom;
    }

    private static ASN1 a(Object object) {
        BigInteger bigInteger = (BigInteger)object;
        ASN1 aSN1 = ASN1.makeSequence(2);
        aSN1.addElement(k);
        aSN1.addElement(new ASN1(2, bigInteger));
        return aSN1;
    }

    private static ASN1 a(int n, BigInteger bigInteger, ASN1 aSN1) {
        ASN1 aSN12 = ASN1.makeSequence(2);
        aSN12.addElement(new ASN1(2, bigInteger));
        aSN12.addElement(new ASN1(Integer.MIN_VALUE | n, (Object)aSN1));
        return aSN12;
    }

    private void a(ASN1 aSN1) throws IOException {
        Enumeration enumeration = aSN1.gvVector().elements();
        block6: while (enumeration.hasMoreElements()) {
            ASN1 aSN12 = (ASN1)enumeration.nextElement();
            BigInteger bigInteger = aSN12.getElementAt(0).gvBigInteger();
            ASN1 aSN13 = aSN12.getElementAt(1).gvASN1();
            int n = aSN12.getElementAt(1).getTypeOnly();
            switch (n) {
                case 0: {
                    Object object3;
                    X509Certificate[] x509CertificateArray;
                    Object object2;
                    Enumeration enumeration2 = aSN13.gvVector().elements();
                    while (enumeration2.hasMoreElements()) {
                        object2 = (ASN1)enumeration2.nextElement();
                        x509CertificateArray = ((ASN1)object2).getElementAt(0).gvString();
                        object3 = ((ASN1)object2).getElementAt(1).getElementAt(1).gvBigInteger();
                        this.c.put(x509CertificateArray, object3);
                    }
                    continue block6;
                }
                case 1: {
                    byte[] byArray = aSN13.gvByteArray();
                    Object object2 = new PrivateKey(byArray);
                    this.b.put(bigInteger, object2);
                    break;
                }
                case 2: {
                    byte[] byArray = aSN13.gvByteArray();
                    Object object2 = new X509Certificate(byArray);
                    this.b.put(bigInteger, object2);
                    break;
                }
                case 3: {
                    Object object;
                    int n2 = aSN13.gvVector().size();
                    Object object2 = null;
                    X509Certificate[] x509CertificateArray = new X509Certificate[n2 - 1];
                    Object object3 = aSN13.getElementAt(0);
                    if (((ASN1)object3).getType() != 5) {
                        object2 = (PrivateKey)this.b.get(((ASN1)object3).getElementAt(1).gvBigInteger());
                    }
                    int n3 = 1;
                    while (n3 < n2) {
                        object = aSN13.getElementAt(n3).getElementAt(1).gvBigInteger();
                        x509CertificateArray[n3 - 1] = (X509Certificate)this.b.get(object);
                        ++n3;
                    }
                    if (object2 == null) {
                        this.b.put(bigInteger, x509CertificateArray);
                        break;
                    }
                    object = new KeyAndCert(x509CertificateArray, (PrivateKey)object2);
                    this.b.put(bigInteger, object);
                    break;
                }
                default: {
                    throw new IOException("Invalid file type: " + n);
                }
            }
        }
    }

    private void a(ASN1 aSN1, char[] cArray) throws IOException, CryptoException {
        ASN1 aSN12 = aSN1.getElementAt(0);
        byte[] byArray = aSN1.getElementAt(1).gvByteArray();
        Cipher cipher = PBE.getCipher(aSN12, cArray);
        byte[] byArray2 = cipher.doFinal(byArray);
        ASN1 aSN13 = new ASN1(byArray2, 0, false);
        this.a(aSN13);
    }

    public PrivateKey getPrivateKey(String string) throws CryptoException {
        Object v = this.d.get(string);
        if (v != null) {
            if (v instanceof PrivateKey) {
                return (PrivateKey)v;
            }
            if (v instanceof KeyAndCert) {
                return ((KeyAndCert)v).getPrivateKey();
            }
        }
        return null;
    }

    public KeyAndCert getKeyAndCert(String string) throws CryptoException {
        Object v = this.d.get(string);
        if (v != null && v instanceof KeyAndCert) {
            return (KeyAndCert)v;
        }
        return null;
    }

    public Object getEntry(String string) {
        return this.d.get(string);
    }

    public X509Certificate[] getCertificateChain(String string) {
        Object v = this.d.get(string);
        if (v != null) {
            if (v instanceof X509Certificate[]) {
                return (X509Certificate[])v;
            }
            if (v instanceof KeyAndCert) {
                return ((KeyAndCert)v).getCertificateChain();
            }
        }
        return null;
    }

    public void deleteEntry(String string) {
        this.d.remove(string);
    }

    private void a(InputStream inputStream, char[] cArray) throws IOException, CryptoException {
        ASN1 aSN1;
        Object object;
        Object object2;
        ASN1 aSN12 = new ASN1(inputStream, 1, false);
        if (aSN12.getType() != 16) {
            throw new IOException("Not an IAIK keystore");
        }
        if (aSN12.getElementAt(0).getType() != 6) {
            throw new CryptoException("Old Keystore Format! 6");
        }
        aSN12.clearEncoding(false);
        String string = aSN12.getElementAt(0).gvString();
        if (!string.equals(e)) {
            throw new IOException("Unknown v3 keystore oid " + string);
        }
        byte[] byArray = aSN12.getElementAt(2).gvByteArray();
        ASN1 aSN13 = aSN12.getElementAt(1);
        Mac mac = PBE.getMac(aSN13.getElementAt(0), cArray);
        byte[] byArray2 = aSN13.getElementAt(1).gvByteArray();
        if (!CryptoUtils.equalsBlock(mac.doFinal(byArray), byArray2)) {
            throw new CryptoException("Mac values do not match");
        }
        this.c = new Hashtable();
        this.b = new Hashtable();
        ASN1 aSN14 = new ASN1(byArray, 0, false);
        Enumeration enumeration = aSN14.gvVector().elements();
        while (enumeration.hasMoreElements()) {
            object2 = (ASN1)enumeration.nextElement();
            object = ((ASN1)object2).getElementAt(2);
            aSN1 = ((ASN1)object).gvASN1();
            switch (((ASN1)object).getType()) {
                case -2147483648: {
                    this.a(aSN1);
                    break;
                }
                case -2147483647: {
                    this.a(aSN1, cArray);
                    break;
                }
                default: {
                    throw new IOException("Unsupported record type: " + ((ASN1)object2).getTypeOnly());
                }
            }
        }
        object2 = this.c.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            aSN1 = this.c.get(object);
            this.d.put(object, this.b.get(aSN1));
        }
        this.c = null;
        this.b = null;
    }

    public Enumeration aliases() {
        return this.d.keys();
    }

    public void addKeyEntry(String string, PrivateKey privateKey) {
        this.d.put(string, privateKey);
    }

    public void addKeyAndCertEntry(String string, PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        this.d.put(string, new KeyAndCert(x509CertificateArray, privateKey));
    }

    public void addKeyAndCertEntry(String string, KeyAndCert keyAndCert) {
        this.d.put(string, keyAndCert);
    }

    public void addCertificateEntry(String string, X509Certificate x509Certificate) {
        X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate};
        this.d.put(string, x509CertificateArray);
    }

    public void addCertificateChainEntry(String string, X509Certificate[] x509CertificateArray) {
        this.d.put(string, x509CertificateArray);
    }

    public KeyStore(InputStream inputStream, char[] cArray) throws IOException, CryptoException {
        this();
        this.a(inputStream, cArray);
    }

    public KeyStore() {
    }

    static {
        SysUtil.toString(null, -1, 1, ":");
    }
}

