/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.keymgmt;

import iaik.me.security.PrivateKey;
import iaik.me.utils.Util;
import iaik.me.x509.X509Certificate;

public class KeyAndCert {
    private PrivateKey a;
    private X509Certificate[] b;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Private key: ");
        stringBuffer.append(this.a.getKeyLength());
        stringBuffer.append(" bit\r\n");
        stringBuffer.append(this.b.length);
        stringBuffer.append(" certificates:\r\n");
        int n = 0;
        while (n < this.b.length) {
            stringBuffer.append("  ");
            stringBuffer.append(this.b[n].getSubjectDN());
            stringBuffer.append("\r\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public final PrivateKey getPrivateKey() {
        return this.a;
    }

    public final X509Certificate[] getCertificateChain() {
        return this.b;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof KeyAndCert)) {
            return false;
        }
        KeyAndCert keyAndCert = (KeyAndCert)object;
        if (!this.a.equals(keyAndCert.a)) {
            return false;
        }
        if (this.b.length != keyAndCert.b.length) {
            return false;
        }
        int n = 0;
        while (n < this.b.length) {
            if (!this.b[n].equals(keyAndCert.b[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public KeyAndCert(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        if (privateKey == null || Util.isNull(x509CertificateArray)) {
            throw new NullPointerException("CertificateChain and PrivateKey may not be null!");
        }
        this.b = x509CertificateArray;
        this.a = privateKey;
    }
}

