/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.mocca;

import at.gv.egiz.smcc.SignatureCard;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.x509.CertificateToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MOCCAPrivateKeyEntry
implements DSSPrivateKeyEntry {
    private static final Logger LOG = LoggerFactory.getLogger(MOCCAPrivateKeyEntry.class);
    private CertificateToken signingCert;
    private SignatureCard.KeyboxName keyboxName;
    private int index;
    private byte[] atr;
    private EncryptionAlgorithm encryptionAlgorithm;
    private CertificateToken[] certificateChain = new CertificateToken[1];

    public MOCCAPrivateKeyEntry(byte[] signingCert, SignatureCard.KeyboxName keyboxName, int index, byte[] atr) {
        this.initialise(signingCert, keyboxName, atr);
        this.index = index;
    }

    private void initialise(byte[] signingCertBinary, SignatureCard.KeyboxName keyboxName, byte[] atr) {
        this.signingCert = DSSUtils.loadCertificate(signingCertBinary);
        LOG.info(">>>Signing certificate subject name/serial number: " + this.signingCert.getSubjectX500Principal().getName() + "/" + this.signingCert.getSerialNumber());
        this.keyboxName = keyboxName;
        if (keyboxName == null) {
            throw new DSSException("KeyboxName is missing");
        }
        this.atr = atr;
        String encryptionAlgo = this.signingCert.getPublicKey().getAlgorithm();
        this.encryptionAlgorithm = EncryptionAlgorithm.forName(encryptionAlgo);
        LOG.info("MOCCA>>>EncryptionAlgorithm from public key: " + this.encryptionAlgorithm.getName());
        this.certificateChain[0] = this.signingCert;
    }

    @Override
    public CertificateToken getCertificate() {
        return this.signingCert;
    }

    @Override
    public CertificateToken[] getCertificateChain() {
        return this.certificateChain;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() throws DSSException {
        return this.encryptionAlgorithm;
    }

    public String getX509SignatureAlgorithmName() {
        return this.signingCert.getCertificate().getSigAlgName();
    }

    public SignatureCard.KeyboxName getKeyboxName() {
        return this.keyboxName;
    }

    public int getPos() {
        return this.index;
    }

    public byte[] getAtr() {
        return this.atr;
    }
}

