/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.token.AbstractKeyStoreTokenConnection;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.PrefilledPasswordCallback;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.util.UUID;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class Pkcs11SignatureToken
extends AbstractKeyStoreTokenConnection {
    private static final String NEW_LINE = "\n";
    private Provider provider;
    private final String _pkcs11Path;
    private final PasswordInputCallback callback;
    private final int slotId;

    public Pkcs11SignatureToken(String pkcs11Path) {
        this(pkcs11Path, (PasswordInputCallback)null);
    }

    public Pkcs11SignatureToken(String pkcs11Path, KeyStore.PasswordProtection password) {
        this(pkcs11Path, password, 0);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback) {
        this(pkcs11Path, callback, 0);
    }

    public Pkcs11SignatureToken(String pkcs11Path, KeyStore.PasswordProtection password, int slotId) {
        this(pkcs11Path, new PrefilledPasswordCallback(password), slotId);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback, int slotId) {
        this._pkcs11Path = pkcs11Path;
        this.callback = callback;
        this.slotId = slotId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Provider getProvider() {
        if (this.provider != null) return this.provider;
        String aPKCS11LibraryFileName = this.getPkcs11Path();
        aPKCS11LibraryFileName = this.escapePath(aPKCS11LibraryFileName);
        StringBuilder pkcs11Config = new StringBuilder();
        pkcs11Config.append("name = SmartCard").append(UUID.randomUUID().toString()).append(NEW_LINE);
        pkcs11Config.append("library = \"").append(aPKCS11LibraryFileName).append("\"").append(NEW_LINE);
        pkcs11Config.append("slot = ").append(this.slotId);
        String configString = pkcs11Config.toString();
        LOG.debug("PKCS11 Config : \n{}", (Object)configString);
        try (ByteArrayInputStream confStream = new ByteArrayInputStream(configString.getBytes());){
            SunPKCS11 sunPKCS11 = new SunPKCS11((InputStream)confStream);
            Security.addProvider(sunPKCS11);
            Provider provider = this.provider = sunPKCS11;
            return provider;
        }
        catch (Exception e) {
            throw new DSSException("Unable to instantiate SunPKCS11", e);
        }
    }

    private String escapePath(String pathToEscape) {
        if (pathToEscape != null) {
            return pathToEscape.replace("\\", "\\\\");
        }
        return "";
    }

    @Override
    KeyStore getKeyStore() throws DSSException {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS11", this.getProvider());
            keyStore.load(new KeyStore.LoadStoreParameter(){

                @Override
                public KeyStore.ProtectionParameter getProtectionParameter() {
                    return new KeyStore.CallbackHandlerProtection(new CallbackHandler(){

                        @Override
                        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                            for (Callback c : callbacks) {
                                if (!(c instanceof PasswordCallback)) continue;
                                ((PasswordCallback)c).setPassword(Pkcs11SignatureToken.this.callback.getPassword());
                                return;
                            }
                            throw new RuntimeException("No password callback");
                        }
                    });
                }
            });
            return keyStore;
        }
        catch (Exception e) {
            if (e instanceof PKCS11Exception && "CKR_PIN_INCORRECT".equals(e.getMessage())) {
                throw new DSSException("Bad password for PKCS11", e);
            }
            throw new DSSException("Can't initialize Sun PKCS#11 security provider. Reason: " + e.getMessage(), e);
        }
    }

    protected String getPkcs11Path() {
        return this._pkcs11Path;
    }

    @Override
    KeyStore.PasswordProtection getKeyProtectionParameter() {
        return null;
    }

    @Override
    protected Signature getSignatureInstance(String javaSignatureAlgorithm) throws NoSuchAlgorithmException {
        return Signature.getInstance(javaSignatureAlgorithm, this.getProvider());
    }

    @Override
    public void close() {
        if (this.provider != null) {
            try {
                Security.removeProvider(this.provider.getName());
            }
            catch (SecurityException e) {
                LOG.error("Unable to remove provider '" + this.provider.getName() + "'", e);
            }
            finally {
                this.provider = null;
            }
        }
    }
}

