/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.http;

public enum Protocol {
    FILE("file"),
    HTTP("http"),
    HTTPS("https"),
    LDAP("ldap"),
    FTP("ftp");

    private String name;

    private Protocol(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static boolean isHttps(String name) {
        return Protocol.HTTPS.name.equalsIgnoreCase(name);
    }

    public static boolean isHttp(String name) {
        return Protocol.HTTP.name.equalsIgnoreCase(name);
    }

    public static boolean isFileUrl(String urlString) {
        return urlString != null && urlString.startsWith(Protocol.FILE.name);
    }

    public static boolean isHttpUrl(String urlString) {
        return urlString != null && urlString.startsWith(Protocol.HTTP.name);
    }

    public static boolean isFtpUrl(String urlString) {
        return urlString != null && urlString.startsWith(Protocol.FTP.name);
    }

    public static boolean isLdapUrl(String urlString) {
        return urlString != null && urlString.startsWith(Protocol.LDAP.name);
    }

    public boolean isTheSame(String urlString) {
        return urlString != null && urlString.startsWith(this.name);
    }

    public static Protocol getFrom(String urlString) {
        if (HTTP.isTheSame(urlString)) {
            return HTTP;
        }
        if (HTTPS.isTheSame(urlString)) {
            return HTTPS;
        }
        if (LDAP.isTheSame(urlString)) {
            return LDAP;
        }
        if (FTP.isTheSame(urlString)) {
            return FTP;
        }
        if (FILE.isTheSame(urlString)) {
            return FILE;
        }
        return null;
    }
}

