/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.ocsp.ResponseBytes;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public final class DSSRevocationUtils {
    private static JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();

    private DSSRevocationUtils() {
    }

    public static final BasicOCSPResp fromRespToBasic(OCSPResp ocspResp) throws DSSException {
        try {
            return (BasicOCSPResp)ocspResp.getResponseObject();
        }
        catch (OCSPException e) {
            throw new DSSException(e);
        }
    }

    public static final OCSPResp fromBasicToResp(BasicOCSPResp basicOCSPResp) throws DSSException {
        try {
            byte[] encoded = basicOCSPResp.getEncoded();
            OCSPResp ocspResp = DSSRevocationUtils.fromBasicToResp(encoded);
            return ocspResp;
        }
        catch (IOException e) {
            throw new DSSException(e);
        }
    }

    public static final OCSPResp fromBasicToResp(byte[] basicOCSPRespBinary) {
        OCSPResponseStatus responseStatus = new OCSPResponseStatus(0);
        DEROctetString derBasicOCSPResp = new DEROctetString(basicOCSPRespBinary);
        ResponseBytes responseBytes = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp_basic, derBasicOCSPResp);
        OCSPResponse ocspResponse = new OCSPResponse(responseStatus, responseBytes);
        OCSPResp ocspResp = new OCSPResp(ocspResponse);
        return ocspResp;
    }

    public static boolean matches(CertificateID certId, SingleResp singleResp) {
        CertificateID singleRespCertID = singleResp.getCertID();
        ASN1ObjectIdentifier singleRespCertIDHashAlgOID = singleRespCertID.getHashAlgOID();
        byte[] singleRespCertIDIssuerKeyHash = singleRespCertID.getIssuerKeyHash();
        byte[] singleRespCertIDIssuerNameHash = singleRespCertID.getIssuerNameHash();
        BigInteger singleRespCertIDSerialNumber = singleRespCertID.getSerialNumber();
        ASN1ObjectIdentifier certIdHashAlgOID = certId.getHashAlgOID();
        byte[] certIdIssuerKeyHash = certId.getIssuerKeyHash();
        byte[] certIdIssuerNameHash = certId.getIssuerNameHash();
        BigInteger certIdSerialNumber = certId.getSerialNumber();
        return singleRespCertIDHashAlgOID.equals(certIdHashAlgOID) && Arrays.equals(singleRespCertIDIssuerKeyHash, certIdIssuerKeyHash) && Arrays.equals(singleRespCertIDIssuerNameHash, certIdIssuerNameHash) && singleRespCertIDSerialNumber.equals(certIdSerialNumber);
    }

    public static CertificateID getOCSPCertificateID(CertificateToken cert, CertificateToken issuerCert) throws DSSException {
        try {
            BigInteger serialNumber = cert.getSerialNumber();
            DigestCalculator digestCalculator = DSSRevocationUtils.getSHA1DigestCalculator();
            X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder(issuerCert);
            return new CertificateID(digestCalculator, x509CertificateHolder, serialNumber);
        }
        catch (OCSPException e) {
            throw new DSSException("Unable to create CertificateID", e);
        }
    }

    public static DigestCalculator getSHA1DigestCalculator() throws DSSException {
        try {
            DigestCalculatorProvider digestCalculatorProvider = jcaDigestCalculatorProviderBuilder.build();
            DigestCalculator digestCalculator = digestCalculatorProvider.get(CertificateID.HASH_SHA1);
            return digestCalculator;
        }
        catch (OperatorCreationException e) {
            throw new DSSException("Unable to create a DigestCalculator instance", e);
        }
    }

    public static BasicOCSPResp loadOCSPBase64Encoded(String base64Encoded) throws IOException {
        byte[] derEncoded = Utils.fromBase64(base64Encoded);
        OCSPResp ocspResp = new OCSPResp(derEncoded);
        return DSSRevocationUtils.fromRespToBasic(ocspResp);
    }

    public static byte[] getEncoded(OCSPResp ocspResp) {
        try {
            byte[] encoded = ocspResp.getEncoded();
            return encoded;
        }
        catch (IOException e) {
            throw new DSSException(e);
        }
    }

    static {
        jcaDigestCalculatorProviderBuilder.setProvider("BC");
    }
}

