/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;

public final class ScreenUtil {
    public static Rectangle getScreenBoundsAt(Point pos) {
        GraphicsDevice gd = ScreenUtil.getGraphicsDeviceAt(pos);
        Rectangle bounds = null;
        if (gd != null) {
            bounds = gd.getDefaultConfiguration().getBounds();
        }
        return bounds;
    }

    public static GraphicsDevice getGraphicsDeviceAt(Point pos) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = ge.getScreenDevices();
        GraphicsDevice device = null;
        for (GraphicsDevice device1 : screenDevices) {
            GraphicsConfiguration gc = device1.getDefaultConfiguration();
            Rectangle screenBounds = gc.getBounds();
            if (!screenBounds.contains(pos)) continue;
            device = device1;
            break;
        }
        if (device == null) {
            device = ge.getDefaultScreenDevice();
        }
        return device;
    }

    private ScreenUtil() {
    }
}

