/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.nativeUI;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.nativeUI.AwtMenu;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.util.SwingUtil;
import java.awt.CheckboxMenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class AwtMenuItemCheckbox
implements CheckboxPeer {
    private final AwtMenu parent;
    private final CheckboxMenuItem _native = new CheckboxMenuItem();
    private volatile ActionListener callback;
    private volatile boolean isChecked = false;

    AwtMenuItemCheckbox(AwtMenu parent) {
        this.parent = parent;
    }

    @Override
    public void setEnabled(final Checkbox menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItemCheckbox.this._native.setEnabled(menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(final Checkbox menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItemCheckbox.this._native.setLabel(menuItem.getText());
            }
        });
    }

    @Override
    public void setCallback(final Checkbox menuItem) {
        if (this.callback != null) {
            this._native.removeActionListener(this.callback);
        }
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    menuItem.setChecked(!AwtMenuItemCheckbox.this.isChecked);
                    ActionListener cb = menuItem.getCallback();
                    if (cb != null) {
                        try {
                            cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                        }
                    }
                }
            };
            this._native.addActionListener(this.callback);
        }
    }

    @Override
    public void setShortcut(Checkbox menuItem) {
        char shortcut = menuItem.getShortcut();
        final int vKey = SwingUtil.getVirtualKey(shortcut);
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItemCheckbox.this._native.setShortcut(new MenuShortcut(vKey));
            }
        });
    }

    @Override
    public void setChecked(Checkbox menuItem) {
        this.isChecked = menuItem.getChecked();
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItemCheckbox.this._native.setState(AwtMenuItemCheckbox.this.isChecked);
            }
        });
    }

    @Override
    public void remove() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItemCheckbox.this._native.deleteShortcut();
                AwtMenuItemCheckbox.this._native.setEnabled(false);
                if (AwtMenuItemCheckbox.this.callback != null) {
                    AwtMenuItemCheckbox.this._native.removeActionListener(AwtMenuItemCheckbox.this.callback);
                    AwtMenuItemCheckbox.this.callback = null;
                }
                ((AwtMenuItemCheckbox)AwtMenuItemCheckbox.this).parent._native.remove(AwtMenuItemCheckbox.this._native);
                AwtMenuItemCheckbox.this._native.removeNotify();
            }
        });
    }
}

