/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.util;

public class TLV {
    private byte[] bytes;
    private int start;

    public TLV(byte[] byArray, int n) {
        if (byArray.length - n < 2) {
            throw new IllegalArgumentException("TLV must at least consit of tag and length.");
        }
        this.bytes = byArray;
        this.start = n;
    }

    public int getTag() {
        return 0xFF & this.bytes[this.start];
    }

    public int getLengthFieldLength() {
        if ((this.bytes[this.start + 1] & 0x80) > 0) {
            return 1 + (this.bytes[this.start + 1] & 7);
        }
        return 1;
    }

    public int getLength() {
        if ((this.bytes[this.start + 1] & 0x80) > 0) {
            int n = 0;
            for (int i = 0; i < (this.bytes[this.start + 1] & 7); ++i) {
                n <<= 8;
                n += this.bytes[this.start + 2 + i] & 0xFF;
            }
            return n;
        }
        return this.bytes[this.start + 1] & 0x7F;
    }

    public byte[] getValue() {
        byte[] byArray = new byte[this.getLength()];
        System.arraycopy(this.bytes, this.start + 1 + this.getLengthFieldLength(), byArray, 0, byArray.length);
        return byArray;
    }

    public String toString() {
        return "Tag = " + Integer.toHexString(this.getTag()) + ", Length = " + this.getLength() + ", Value = " + TLV.toString(this.getValue());
    }

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (byArray != null && byArray.length > 0) {
            stringBuffer.append(Integer.toHexString((byArray[0] & 0xF0) >> 4));
            stringBuffer.append(Integer.toHexString(byArray[0] & 0xF));
            for (int i = 1; i < byArray.length; ++i) {
                stringBuffer.append(i % 32 == 0 ? (char)'\n' : ':');
                stringBuffer.append(Integer.toHexString((byArray[i] & 0xF0) >> 4));
                stringBuffer.append(Integer.toHexString(byArray[i] & 0xF));
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

