/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.util;

import at.gv.egiz.smcc.util.MSCMConstants;
import at.gv.egiz.smcc.util.MSCMException;
import at.gv.egiz.smcc.util.MSCMService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class MSCMDecoder
implements MSCMConstants {
    private static Map<Integer, String> namespaces = new HashMap<Integer, String>();
    private static Map<Short, String> types;
    private static Map<Short, String> exceptions;

    public static void checkExceptionInResponse(byte[] byArray, int n) throws MSCMException {
        String string;
        short s;
        String string2 = null;
        if (byArray[n] == -1) {
            s = MSCMService.bytesToShort(byArray, n + 5);
            if (byArray.length > n + 7) {
                try {
                    string2 = MSCMDecoder.decodeString(byArray, n + 7);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
        } else {
            s = MSCMService.bytesToShort(byArray, n + 4);
            if (byArray.length > n + 6) {
                try {
                    string2 = MSCMDecoder.decodeString(byArray, n + 6);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
        }
        if ((string = exceptions.get(s)) != null) {
            if (string2 == null) {
                throw new MSCMException(s, string);
            }
            throw new MSCMException(s, string, string2);
        }
    }

    public static String namespaceHiveToString(byte[] byArray, int n) {
        int n2 = MSCMService.bytesToInt(byArray, n);
        String string = namespaces.get(n2);
        if (string == null) {
            string = MSCMService.bytArrayToHex(byArray);
        }
        return string;
    }

    public static String typeHiveToString(byte[] byArray, int n) {
        short s = MSCMService.bytesToShort(byArray, n);
        String string = types.get(s);
        if (string == null) {
            string = MSCMService.bytArrayToHex(byArray);
        }
        return string;
    }

    public static boolean decodeBoolean(byte by) {
        return by == 1;
    }

    public static byte[] decodeByteArray(byte[] byArray, int n) {
        int n2 = MSCMService.bytesToInt(byArray, n);
        if (n2 > byArray.length - n - 4) {
            return null;
        }
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[n + 4 + i];
        }
        return byArray2;
    }

    public static short[] decodeShortArray(byte[] byArray, int n) {
        int n2 = MSCMService.bytesToInt(byArray, n);
        if (n2 * 2 > byArray.length - n - 4) {
            return null;
        }
        short[] sArray = new short[n2];
        for (int i = 0; i < n2; ++i) {
            sArray[i] = MSCMService.bytesToShort(byArray, n + 4 + i * 2);
        }
        return sArray;
    }

    public static int[] decodeIntArray(byte[] byArray, int n) {
        int n2 = MSCMService.bytesToInt(byArray, n);
        if (n2 * 4 > byArray.length - n - 4) {
            return null;
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = MSCMService.bytesToInt(byArray, n + 4 + i * 4);
        }
        return nArray;
    }

    public static String[] decodeStringArray(byte[] byArray, int n) throws UnsupportedEncodingException {
        int n2 = MSCMService.bytesToInt(byArray, n);
        String[] stringArray = new String[n2];
        int n3 = 4;
        for (int i = 0; i < n2; ++i) {
            short s = MSCMService.bytesToShort(byArray, n + n3);
            stringArray[i] = MSCMDecoder.decodeString(byArray, n + n3);
            n3 += s + 2;
        }
        return stringArray;
    }

    public static String decodeString(byte[] byArray, int n) throws UnsupportedEncodingException {
        int n2 = MSCMService.bytesToShort(byArray, n);
        if (n2 == 65535) {
            return "";
        }
        byte[] byArray2 = new byte[n2 * 2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[n + 2 + i];
        }
        String string = new String(byArray2, "UTF-8");
        return string;
    }

    public static byte[] encodeString(String string) throws IOException {
        if (string == null) {
            return new byte[]{-1, -1};
        }
        byte[] byArray = string.getBytes("UTF-8");
        short s = (short)byArray.length;
        byte[] byArray2 = MSCMService.shortToBytes(s);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(s + 2);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] encodeByteArray(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = MSCMService.intToBytes(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n + 4);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] concatByteArrays(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length + byArray2.length);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    static {
        namespaces.put(13786396, "System");
        namespaces.put(14018267, "System.IO");
        namespaces.put(34926, "System.Runtime.Remoting.Channels");
        namespaces.put(10595385, "Netcard.Filesystem");
        namespaces.put(15416793, "System.Runtime.Remoting");
        namespaces.put(11334971, "System.Security.Cryptography");
        namespaces.put(12951568, "System.Collections");
        namespaces.put(2050452, "System.Runtime.Remoting.Contexts");
        namespaces.put(9847109, "System.Security");
        namespaces.put(554255, "System.Reflection");
        namespaces.put(9255741, "System.Runtime.Serialization");
        namespaces.put(14596416, "System.Runtime.Remoting.Messaging");
        namespaces.put(9935199, "System.Diagnostics");
        namespaces.put(16137745, "System.Runtime.Compilerservices");
        namespaces.put(7350102, "System.Text");
        namespaces.put(16117695, "Smartcard");
        types = new HashMap<Short, String>();
        types.put((short)-12671, "System.Void");
        types.put((short)25024, "System.Int32");
        types.put((short)25025, "System.Int32[]");
        types.put((short)8743, "System.Boolean");
        types.put((short)8744, "System.Boolean[]");
        types.put((short)30334, "System.SByte");
        types.put((short)30335, "System.SByte[]");
        types.put((short)-9845, "System.UInt16");
        types.put((short)-9844, "System.UInt16[]");
        types.put((short)-27161, "System.UInt32");
        types.put((short)-27160, "System.UInt32[]");
        types.put((short)17826, "System.Byte");
        types.put((short)17827, "System.Byte[]");
        types.put((short)-27250, "System.Char");
        types.put((short)-27249, "System.Char[]");
        types.put((short)-17351, "System.Int16");
        types.put((short)-17350, "System.Int16[]");
        types.put((short)4391, "System.String");
        types.put((short)4392, "System.String[]");
        types.put((short)-8453, "System.Int64");
        types.put((short)-8452, "System.Int64[]");
        types.put((short)29103, "System.UInt64");
        types.put((short)29104, "System.UInt64[]");
        types.put((short)-297, "System.IO.MemoryStream");
        exceptions = new HashMap<Short, String>();
        exceptions.put((short)-11088, "System.Exception");
        exceptions.put((short)10412, "System.SystemException");
        exceptions.put((short)-7858, "System.OutOfMemoryException");
        exceptions.put((short)-21620, "System.ArgumentException");
        exceptions.put((short)8504, "System.ArgumentNullException");
        exceptions.put((short)-14920, "System.NullReferenceException");
        exceptions.put((short)27409, "System.ArgumentOutOfRangeException");
        exceptions.put((short)-21900, "System.NotSupportedException");
        exceptions.put((short)-11697, "System.InvalidCastException");
        exceptions.put((short)-1356, "System.InvalidOperationException");
        exceptions.put((short)15589, "System.NotImplementedException");
        exceptions.put((short)4012, "System.ObjectDisposed Exception");
        exceptions.put((short)18071, "System.UnauthorizedAccessException");
        exceptions.put((short)-16611, "System.IndexOutOfRangeException");
        exceptions.put((short)-3137, "System.FormatException");
        exceptions.put((short)26243, "System.ArithmeticException");
        exceptions.put((short)8352, "System.OverflowException");
        exceptions.put((short)21258, "System.BadImageFormatException");
        exceptions.put((short)-19990, "System.ApplicationException");
        exceptions.put((short)16264, "System.ArrayTypeMismatchException");
        exceptions.put((short)-8241, "System.DivideByZeroException");
        exceptions.put((short)-2573, "System.MemberAccessException");
        exceptions.put((short)8379, "System.MissingMemberException");
        exceptions.put((short)29542, "System.MissingFieldException");
        exceptions.put((short)-28581, "System.MissingMethodException");
        exceptions.put((short)-19794, "System.RankException");
        exceptions.put((short)2116, "System.StackOverflowException");
        exceptions.put((short)1166, "System.TypeLoadException");
        exceptions.put((short)15294, "System.IO.IOException");
        exceptions.put((short)-26790, "System.IO.DirectoryNotFoundException");
        exceptions.put((short)2027, "System.IO.FileNotFoundException");
        exceptions.put((short)-10966, "System.Runtime.Remoting.RemotingException");
        exceptions.put((short)-28693, "System.Security.Cryptography.CryptographicException");
    }
}

