/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.util;

import at.gv.egiz.smcc.ChangeReferenceDataAPDUSpec;
import at.gv.egiz.smcc.NewReferenceDataAPDUSpec;
import at.gv.egiz.smcc.SecurityStatusNotSatisfiedException;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.util.TransparentFileInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class ISO7816Utils {
    public static final byte TAG_FCP = 98;
    public static final byte TAG_FMD = 100;
    public static final byte TAG_FCI = 111;
    public static final byte P2_FCI = 0;
    public static final byte P2_FCP = 4;
    public static final byte P2_FMD = 8;
    public static final byte P2_NORESP = 12;

    public static TransparentFileInputStream openTransparentFileInputStream(CardChannel cardChannel, int n) {
        return ISO7816Utils.openTransparentFileInputStream(cardChannel, n, 256);
    }

    public static TransparentFileInputStream openTransparentFileInputStream(final CardChannel cardChannel, int n, int n2) {
        TransparentFileInputStream transparentFileInputStream = new TransparentFileInputStream(n, n2){

            @Override
            protected byte[] readBinary(int n, int n2) throws IOException {
                ResponseAPDU responseAPDU;
                if (n2 < 1) {
                    return new byte[0];
                }
                try {
                    responseAPDU = cardChannel.transmit(new CommandAPDU(0, 176, 0x7F & n >> 8, n & 0xFF, n2));
                }
                catch (CardException cardException) {
                    throw new IOException(cardException);
                }
                if (responseAPDU.getSW1() == 108) {
                    try {
                        responseAPDU = cardChannel.transmit(new CommandAPDU(0, 176, 0x7F & n >> 8, n & 0xFF, responseAPDU.getSW2()));
                    }
                    catch (CardException cardException) {
                        throw new IOException("Error reading bytes from card.", cardException);
                    }
                }
                if (responseAPDU.getSW() == 36864) {
                    return responseAPDU.getData();
                }
                SignatureCardException signatureCardException = responseAPDU.getSW() == 27010 ? new SecurityStatusNotSatisfiedException() : new SignatureCardException("Failed to read bytes (offset=" + n + ",len=" + n2 + ") SW=" + Integer.toHexString(responseAPDU.getSW()) + ".");
                throw new IOException(signatureCardException);
            }
        };
        return transparentFileInputStream;
    }

    private static byte[] readFromInputStream(TransparentFileInputStream transparentFileInputStream) throws CardException, SignatureCardException {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[256];
            while ((n = transparentFileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.getCause();
            if (throwable instanceof CardException) {
                throw (CardException)throwable;
            }
            if (throwable instanceof SignatureCardException) {
                throw (SignatureCardException)throwable;
            }
            throw new SignatureCardException(iOException);
        }
    }

    public static byte[] readTransparentFile(CardChannel cardChannel, int n, int n2) throws CardException, SignatureCardException {
        TransparentFileInputStream transparentFileInputStream = ISO7816Utils.openTransparentFileInputStream(cardChannel, n, n2);
        return ISO7816Utils.readFromInputStream(transparentFileInputStream);
    }

    public static byte[] readTransparentFile(CardChannel cardChannel, int n) throws CardException, SignatureCardException {
        TransparentFileInputStream transparentFileInputStream = ISO7816Utils.openTransparentFileInputStream(cardChannel, n);
        return ISO7816Utils.readFromInputStream(transparentFileInputStream);
    }

    public static byte[] readTransparentFileTLV(CardChannel cardChannel, int n, byte by) throws CardException, SignatureCardException {
        TransparentFileInputStream transparentFileInputStream = ISO7816Utils.openTransparentFileInputStream(cardChannel, n);
        return ISO7816Utils.readTransparentFileTLV(transparentFileInputStream, by);
    }

    public static byte[] readTransparentFileTLV(TransparentFileInputStream transparentFileInputStream, byte by) throws CardException, SignatureCardException {
        try {
            transparentFileInputStream.mark(256);
            int n = transparentFileInputStream.read();
            if (n == 0 || n == 255) {
                return null;
            }
            if (n == -1 || by != (0xFF & n)) {
                throw new SignatureCardException("Unexpected TLV type. Expected " + Integer.toHexString(by) + " but was " + Integer.toHexString(n) + ".");
            }
            int n2 = 2;
            n = transparentFileInputStream.read();
            if (n == -1) {
                return null;
            }
            if ((0x80 & n) > 0) {
                int n3 = 0xF & n;
                n2 += n3;
                for (int i = 1; i <= n3; ++i) {
                    n = transparentFileInputStream.read();
                    if (n == -1) {
                        return null;
                    }
                    n2 += (0xFF & n) << (n3 - i) * 8;
                }
            } else {
                n2 += 0xFF & n;
            }
            transparentFileInputStream.reset();
            transparentFileInputStream.setLimit(n2);
            byte[] byArray = new byte[n2];
            if (transparentFileInputStream.read(byArray) == n2) {
                return byArray;
            }
            return null;
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.getCause();
            if (throwable instanceof CardException) {
                throw (CardException)throwable;
            }
            if (throwable instanceof SignatureCardException) {
                throw (SignatureCardException)throwable;
            }
            throw new SignatureCardException(iOException);
        }
    }

    public static int getLengthFromFCx(byte[] byArray) {
        int n = -1;
        if (byArray.length != 0 && (byArray[0] == 98 || byArray[0] == 111)) {
            block3: for (int i = 2; i < byArray[1] - 2; i += 0xFF & byArray[i + 1] + 2) {
                switch (byArray[i]) {
                    case -128: 
                    case -127: {
                        n = 0xFF & byArray[i + 2];
                        for (int j = 1; j < byArray[i + 1]; ++j) {
                            n <<= 8;
                            n += 0xFF & byArray[i + j + 2];
                        }
                        continue block3;
                    }
                }
            }
        }
        return n;
    }

    public static byte[] readRecord(CardChannel cardChannel, int n) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 178, n, 4, 256));
        if (responseAPDU.getSW() == 36864) {
            return responseAPDU.getData();
        }
        throw new SignatureCardException("Failed to read records. SW=" + Integer.toHexString(responseAPDU.getSW()));
    }

    public static void formatPIN(int n, int n2, byte[] byArray, byte[] byArray2, char[] cArray) {
        boolean bl = n2 == 0;
        int n3 = bl ? 0 : byArray.length - 1;
        int n4 = bl ? 1 : -1;
        switch (n) {
            case 0: {
                if (byArray.length < cArray.length) {
                    throw new IllegalArgumentException();
                }
                for (int i = 0; i < cArray.length; ++i) {
                    byArray[n3] = (byte)Character.digit(cArray[i], 10);
                    byArray2[n3] = -1;
                    n3 += n4;
                }
                break;
            }
            case 1: {
                if (byArray.length * 2 < cArray.length) {
                    throw new IllegalArgumentException();
                }
                for (int i = 0; i < cArray.length; ++i) {
                    int n5 = Character.digit(cArray[i], 10);
                    boolean bl2 = i % 2 == 0 ^ bl;
                    int n6 = n3;
                    byArray[n6] = (byte)(byArray[n6] | (bl2 ? n5 : n5 << 4));
                    int n7 = n3;
                    byArray2[n7] = (byte)(byArray2[n7] | (bl2 ? 15 : -16));
                    n3 += i % 2 * n4;
                }
                break;
            }
            case 2: {
                if (byArray.length < cArray.length) {
                    throw new IllegalArgumentException();
                }
                byte[] byArray3 = Charset.forName("ASCII").encode(CharBuffer.wrap(cArray)).array();
                for (int i = 0; i < cArray.length; ++i) {
                    byArray[n3] = byArray3[i];
                    byArray2[n3] = -1;
                    n3 += n4;
                }
                break;
            }
        }
    }

    public static void insertPIN(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < byArray2.length; ++i) {
            int n2 = n + i;
            byArray[n2] = (byte)(byArray[n2] & ~byArray3[i]);
            int n3 = n + i;
            byArray[n3] = (byte)(byArray[n3] | byArray2[i]);
        }
    }

    public static void insertPINLength(byte[] byArray, int n, int n2, int n3, int n4) {
        short s = (short)(0xFF & n);
        short s2 = (short)((1 << n2) - 1);
        int n5 = 16 - n2 - n3 % 8;
        s = (short)(s << n5);
        s2 = (short)(s2 << n5);
        int n6 = n4 += n3 / 8 + 5;
        byArray[n6] = (byte)(byArray[n6] & (0xFF & ~s2 >> 8));
        int n7 = n4;
        byArray[n7] = (byte)(byArray[n7] | 0xFF & s >> 8);
        int n8 = n4 + 1;
        byArray[n8] = (byte)(byArray[n8] & (0xFF & ~s2));
        int n9 = n4 + 1;
        byArray[n9] = (byte)(byArray[n9] | 0xFF & s);
    }

    public static CommandAPDU createVerifyAPDU(VerifyAPDUSpec verifyAPDUSpec, char[] cArray) {
        int n = verifyAPDUSpec.getPinLength() > 0 ? verifyAPDUSpec.getPinLength() : cArray.length;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        ISO7816Utils.formatPIN(verifyAPDUSpec.getPinFormat(), verifyAPDUSpec.getPinJustification(), byArray, byArray2, cArray);
        byte[] byArray3 = verifyAPDUSpec.getApdu();
        byte[] byArray4 = new byte[Math.max(byArray3.length, 5 + verifyAPDUSpec.getPinPosition() + n)];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        if (byArray3.length < 5) {
            byArray4[4] = (byte)(byArray4.length - 5);
        }
        ISO7816Utils.insertPIN(byArray4, verifyAPDUSpec.getPinPosition() + 5, byArray, byArray2);
        if (verifyAPDUSpec.getPinLengthSize() != 0) {
            ISO7816Utils.insertPINLength(byArray4, cArray.length, verifyAPDUSpec.getPinLengthSize(), verifyAPDUSpec.getPinLengthPos(), 0);
        }
        return new CommandAPDU(byArray4);
    }

    public static CommandAPDU createChangeReferenceDataAPDU(ChangeReferenceDataAPDUSpec changeReferenceDataAPDUSpec, char[] cArray, char[] cArray2) {
        int n = changeReferenceDataAPDUSpec.getPinLength() > 0 ? changeReferenceDataAPDUSpec.getPinLength() : cArray.length;
        int n2 = changeReferenceDataAPDUSpec.getPinLength() > 0 ? changeReferenceDataAPDUSpec.getPinLength() : cArray2.length;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        ISO7816Utils.formatPIN(changeReferenceDataAPDUSpec.getPinFormat(), changeReferenceDataAPDUSpec.getPinJustification(), byArray, byArray2, cArray);
        byte[] byArray3 = changeReferenceDataAPDUSpec.getApdu();
        byte[] byArray4 = new byte[Math.max(byArray3.length, 5 + changeReferenceDataAPDUSpec.getPinPosition() + Math.max(changeReferenceDataAPDUSpec.getPinInsertionOffsetOld() + n, changeReferenceDataAPDUSpec.getPinInsertionOffsetNew() + n2))];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        if (byArray3.length < 5) {
            byArray4[4] = (byte)(byArray4.length - 5);
        }
        ISO7816Utils.insertPIN(byArray4, changeReferenceDataAPDUSpec.getPinPosition() + changeReferenceDataAPDUSpec.getPinInsertionOffsetOld() + 5, byArray, byArray2);
        if (changeReferenceDataAPDUSpec.getPinLengthSize() != 0) {
            ISO7816Utils.insertPINLength(byArray4, cArray.length, changeReferenceDataAPDUSpec.getPinLengthSize(), changeReferenceDataAPDUSpec.getPinLengthPos(), changeReferenceDataAPDUSpec.getPinInsertionOffsetOld());
        }
        byArray = new byte[n2];
        byArray2 = new byte[n2];
        ISO7816Utils.formatPIN(changeReferenceDataAPDUSpec.getPinFormat(), changeReferenceDataAPDUSpec.getPinJustification(), byArray, byArray2, cArray2);
        ISO7816Utils.insertPIN(byArray4, changeReferenceDataAPDUSpec.getPinPosition() + changeReferenceDataAPDUSpec.getPinInsertionOffsetNew() + 5, byArray, byArray2);
        if (changeReferenceDataAPDUSpec.getPinLengthSize() != 0) {
            ISO7816Utils.insertPINLength(byArray4, cArray2.length, changeReferenceDataAPDUSpec.getPinLengthSize(), changeReferenceDataAPDUSpec.getPinLengthPos(), changeReferenceDataAPDUSpec.getPinInsertionOffsetNew());
        }
        return new CommandAPDU(byArray4);
    }

    public static CommandAPDU createNewReferenceDataAPDU(NewReferenceDataAPDUSpec newReferenceDataAPDUSpec, char[] cArray) {
        int n = newReferenceDataAPDUSpec.getPinLength() > 0 ? newReferenceDataAPDUSpec.getPinLength() : cArray.length;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        ISO7816Utils.formatPIN(newReferenceDataAPDUSpec.getPinFormat(), newReferenceDataAPDUSpec.getPinJustification(), byArray, byArray2, cArray);
        byte[] byArray3 = newReferenceDataAPDUSpec.getApdu();
        byte[] byArray4 = new byte[Math.max(byArray3.length, 5 + newReferenceDataAPDUSpec.getPinPosition() + n)];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        if (byArray3.length < 5) {
            byArray4[4] = (byte)(byArray4.length - 5);
        }
        ISO7816Utils.insertPIN(byArray4, newReferenceDataAPDUSpec.getPinPosition() + newReferenceDataAPDUSpec.getPinInsertionOffsetNew() + 5, byArray, byArray2);
        if (newReferenceDataAPDUSpec.getPinLengthSize() != 0) {
            ISO7816Utils.insertPINLength(byArray4, cArray.length, newReferenceDataAPDUSpec.getPinLengthSize(), newReferenceDataAPDUSpec.getPinLengthPos(), newReferenceDataAPDUSpec.getPinInsertionOffsetNew());
        }
        return new CommandAPDU(byArray4);
    }
}

