/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.reader;

import at.gv.egiz.smcc.ChangeReferenceDataAPDUSpec;
import at.gv.egiz.smcc.NewReferenceDataAPDUSpec;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.ResetRetryCounterAPDUSpec;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.pin.gui.ModifyPINGUI;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.reader.CardReader;
import at.gv.egiz.smcc.util.ISO7816Utils;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCardReader
implements CardReader {
    private final Logger log = LoggerFactory.getLogger(DefaultCardReader.class);
    protected CardTerminal ct;
    protected String name;

    public DefaultCardReader(CardTerminal cardTerminal) {
        if (cardTerminal == null) {
            throw new NullPointerException("no card or card terminal provided");
        }
        this.ct = cardTerminal;
        this.name = cardTerminal.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAPDU verify(CardChannel cardChannel, VerifyAPDUSpec verifyAPDUSpec, PINGUI pINGUI, PinInfo pinInfo, int n) throws SignatureCardException, CardException, InterruptedException {
        this.log.debug("VERIFY");
        Card card = cardChannel.getCard();
        boolean bl = this.dropExclusive(card);
        try {
            char[] cArray = pINGUI.providePIN(pinInfo, n);
            ResponseAPDU responseAPDU = cardChannel.transmit(ISO7816Utils.createVerifyAPDU(verifyAPDUSpec, cArray));
            return responseAPDU;
        }
        finally {
            this.regainExclusive(card, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAPDU modify(CardChannel cardChannel, ChangeReferenceDataAPDUSpec changeReferenceDataAPDUSpec, ModifyPINGUI modifyPINGUI, PinInfo pinInfo, int n) throws SignatureCardException, CardException, InterruptedException {
        this.log.debug("MODIFY (CHANGE_REFERENCE_DATA)");
        Card card = cardChannel.getCard();
        boolean bl = this.dropExclusive(card);
        try {
            char[] cArray = modifyPINGUI.provideCurrentPIN(pinInfo, n);
            char[] cArray2 = modifyPINGUI.provideNewPIN(pinInfo);
            ResponseAPDU responseAPDU = cardChannel.transmit(ISO7816Utils.createChangeReferenceDataAPDU(changeReferenceDataAPDUSpec, cArray, cArray2));
            return responseAPDU;
        }
        finally {
            this.regainExclusive(card, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAPDU modify(CardChannel cardChannel, NewReferenceDataAPDUSpec newReferenceDataAPDUSpec, ModifyPINGUI modifyPINGUI, PinInfo pinInfo) throws SignatureCardException, CardException, InterruptedException {
        this.log.debug("MODIFY (NEW_REFERENCE_DATA)");
        Card card = cardChannel.getCard();
        boolean bl = this.dropExclusive(card);
        try {
            char[] cArray = modifyPINGUI.provideNewPIN(pinInfo);
            ResponseAPDU responseAPDU = cardChannel.transmit(ISO7816Utils.createNewReferenceDataAPDU(newReferenceDataAPDUSpec, cArray));
            return responseAPDU;
        }
        finally {
            this.regainExclusive(card, bl);
        }
    }

    @Override
    public ResponseAPDU modify(CardChannel cardChannel, ResetRetryCounterAPDUSpec resetRetryCounterAPDUSpec, ModifyPINGUI modifyPINGUI, PinInfo pinInfo, int n) throws InterruptedException, CardException, SignatureCardException {
        this.log.debug("MODIFY (RESET_RETRY_COUNTER)");
        return this.modify(cardChannel, (ChangeReferenceDataAPDUSpec)resetRetryCounterAPDUSpec, modifyPINGUI, pinInfo, n);
    }

    @Override
    public Card connect() throws CardException {
        this.log.debug("connect icc");
        return this.ct.connect("*");
    }

    @Override
    public boolean hasFeature(Byte by) {
        return false;
    }

    private boolean dropExclusive(Card card) throws CardException {
        this.log.debug("Dropping exclusive card access");
        try {
            card.endExclusive();
        }
        catch (IllegalStateException illegalStateException) {
            this.log.debug("Didn't have exclusive access");
            return false;
        }
        return true;
    }

    private void regainExclusive(Card card, boolean bl) throws CardException {
        if (bl) {
            this.log.debug("Trying to regain exclusive card access");
            card.beginExclusive();
        }
    }
}

