/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import iaik.me.asn1.ASN1;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Locale;
import javax.smartcardio.Card;
import javax.smartcardio.CardTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SWCard
implements SignatureCard {
    private static final String BKU_USER_DIR = ".mocca";
    private static final String SWCARD_DIR = "smcc";
    private static final String KEYSTORE_CERTIFIED_KEYPAIR = "certified.p12";
    private static final String KEYSTORE_PASSWORD_CERTIFIED_KEYPAIR = "certified.pwd";
    private static final String CERTIFICATE_CERTIFIED_KEYPAIR = "certified.cer";
    private static final String KEYSTORE_SECURE_KEYPAIR = "secure.p12";
    private static final String KEYSTORE_PASSWORD_SECURE_KEYPAIR = "secure.pwd";
    private static final String CERTIFICATE_SECURE_KEYPAIR = "secure.cer";
    private static String swCardDir;
    private static final Logger log;
    private KeyStore certifiedKeyStore;
    private char[] certifiedKeyStorePassword;
    private KeyStore secureKeyStore;
    private char[] secureKeyStorePassword;
    private Certificate certifiedCertificate;
    private Certificate secureCertificate;

    public static String getSwCardDir() {
        return swCardDir;
    }

    public static void setSwCardDir(String string) {
        swCardDir = string;
    }

    @Override
    public void init(Card card, CardTerminal cardTerminal) {
    }

    @Override
    public Card getCard() {
        return null;
    }

    @Override
    public String getTerminalName() {
        return null;
    }

    private String getFileName(String string) {
        String string2 = System.getProperty("file.separator");
        return swCardDir + string2 + string;
    }

    private Certificate loadCertificate(String string) throws SignatureCardException {
        Certificate certificate;
        FileInputStream fileInputStream;
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("x509");
        }
        catch (CertificateException certificateException) {
            String string2 = "Failed to get CertificateFactory instance for type 'x509'.";
            log.error(string2, certificateException);
            throw new SignatureCardException(string2, certificateException);
        }
        String string3 = this.getFileName(string);
        log.info("Trying to load Certificate from file '" + string3 + "'.");
        try {
            fileInputStream = new FileInputStream(string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string4 = "Certificate file '" + string3 + "' not found.";
            log.info(string4, fileNotFoundException);
            throw new SignatureCardException(string4, fileNotFoundException);
        }
        try {
            certificate = certificateFactory.generateCertificate(fileInputStream);
        }
        catch (CertificateException certificateException) {
            String string5 = "Failed to load Certificate from file '" + string3 + "'.";
            log.info(string5, certificateException);
            throw new SignatureCardException(string5, certificateException);
        }
        return certificate;
    }

    private KeyStore loadKeyStore(String string, char[] cArray) throws SignatureCardException {
        FileInputStream fileInputStream;
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance("pkcs12");
        }
        catch (KeyStoreException keyStoreException) {
            String string2 = "Failed to get KeyStore instance for KeyStore type 'pkcs12'.";
            log.error(string2, keyStoreException);
            throw new SignatureCardException(string2, keyStoreException);
        }
        String string3 = this.getFileName(string);
        log.info("Trying to load KeyStore from file '{}'.", (Object)string3);
        try {
            fileInputStream = new FileInputStream(string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string4 = "KeyStore file '" + string3 + "' not found.";
            log.info(string4, fileNotFoundException);
            throw new SignatureCardException(string4, fileNotFoundException);
        }
        try {
            keyStore.load(fileInputStream, cArray);
        }
        catch (Exception exception) {
            String string5 = "Failed to load KeyStore from file '" + string3 + "'.";
            log.info(string5, exception);
            throw new SignatureCardException(string5, exception);
        }
        return keyStore;
    }

    private char[] loadKeyStorePassword(String string) throws SignatureCardException {
        FileInputStream fileInputStream;
        String string2 = this.getFileName(string);
        try {
            fileInputStream = new FileInputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[16];
            while ((n = inputStreamReader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            char[] cArray2 = stringBuilder.toString().trim().toCharArray();
            return cArray2;
        }
        catch (IOException iOException) {
            throw new SignatureCardException("Failed to read file '" + string + "'.", iOException);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw new SignatureCardException("Failed to close file '" + string + "'.", iOException);
            }
        }
    }

    private KeyStore getKeyStore(SignatureCard.KeyboxName keyboxName, char[] cArray) throws SignatureCardException {
        if (keyboxName == SignatureCard.KeyboxName.CERTIFIED_KEYPAIR) {
            if (this.certifiedKeyStore == null) {
                this.certifiedKeyStore = this.loadKeyStore(KEYSTORE_CERTIFIED_KEYPAIR, cArray);
            }
            return this.certifiedKeyStore;
        }
        if (keyboxName == SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR) {
            if (this.secureKeyStore == null) {
                this.secureKeyStore = this.loadKeyStore(KEYSTORE_SECURE_KEYPAIR, cArray);
            }
            return this.secureKeyStore;
        }
        throw new SignatureCardException("Keybox of type '" + keyboxName + "' not supported.");
    }

    private char[] getPassword(SignatureCard.KeyboxName keyboxName) throws SignatureCardException {
        if (keyboxName == SignatureCard.KeyboxName.CERTIFIED_KEYPAIR) {
            if (this.certifiedKeyStorePassword == null) {
                this.certifiedKeyStorePassword = this.loadKeyStorePassword(KEYSTORE_PASSWORD_CERTIFIED_KEYPAIR);
            }
            return this.certifiedKeyStorePassword;
        }
        if (keyboxName == SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR) {
            if (this.secureKeyStorePassword == null) {
                this.secureKeyStorePassword = this.loadKeyStorePassword(KEYSTORE_PASSWORD_SECURE_KEYPAIR);
            }
            return this.secureKeyStorePassword;
        }
        throw new SignatureCardException("Keybox of type '" + keyboxName + "' not supported.");
    }

    @Override
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException {
        try {
            if (keyboxName == SignatureCard.KeyboxName.CERTIFIED_KEYPAIR) {
                if (this.certifiedCertificate == null) {
                    this.certifiedCertificate = this.loadCertificate(CERTIFICATE_CERTIFIED_KEYPAIR);
                }
                return this.certifiedCertificate.getEncoded();
            }
            if (keyboxName == SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR) {
                if (this.secureCertificate == null) {
                    this.secureCertificate = this.loadCertificate(CERTIFICATE_SECURE_KEYPAIR);
                }
                return this.secureCertificate.getEncoded();
            }
            throw new SignatureCardException("Keybox of type '" + keyboxName + "' not supported.");
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new SignatureCardException("Failed to get encoded Certificate.", certificateEncodingException);
        }
    }

    @Override
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException {
        FileInputStream fileInputStream;
        String string3 = this.getFileName(string + ".ibx");
        try {
            fileInputStream = new FileInputStream(string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string4 = "Infobox '" + string + "' not found.";
            log.info(string4, fileNotFoundException);
            throw new SignatureCardException(string4, fileNotFoundException);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] byArray = new byte[512];
            while ((n = fileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            String string5 = "Failed to read infobox '" + string + "'.";
            log.error(string5, iOException);
            throw new SignatureCardException(string5, iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        char[] cArray = this.getPassword(keyboxName);
        if (cArray == null && (cArray = pINGUI.providePIN((PinInfo)(object4 = new PinInfo(0, -1, ".", "at/gv/egiz/smcc/SWCard", "sw.pin", 1, null, -1)), -1)) == null) {
            return null;
        }
        object4 = this.getKeyStore(keyboxName, cArray);
        Key key = null;
        try {
            object3 = ((KeyStore)object4).aliases();
            while (object3.hasMoreElements() && key == null) {
                object2 = object3.nextElement();
                log.debug("Found alias '{}' in keystore.", object2);
                if (!((KeyStore)object4).isKeyEntry((String)object2)) continue;
                object = null;
                while (object == null) {
                    try {
                        object = ((KeyStore)object4).getKey((String)object2, cArray);
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        log.info("Failed to get Key from KeyStore. Wrong password?", unrecoverableKeyException);
                    }
                }
                key = (PrivateKey)object;
            }
        }
        catch (Exception exception) {
            String string2 = "Failed to get certificate from KeyStore.";
            log.info(string2, exception);
            throw new SignatureCardException(string2, exception);
        }
        if (key == null) {
            object3 = "No private key found in KeyStore.";
            log.info((String)object3);
            throw new SignatureCardException((String)object3);
        }
        object3 = key.getAlgorithm();
        if (((String)object3).equals("RSA")) {
            if (string == null || "http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string)) {
                object3 = "SHA1withRSA";
            } else if ("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256".equals(string)) {
                object3 = "SHA256withRSA";
            }
        } else if (((String)object3).equals("ECDSA")) {
            if (string == null || "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1".equals(string)) {
                object3 = "SHA1withECDSA";
            } else if ("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256".equals(string)) {
                object3 = "SHA256withECDSA";
            } else if ("http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160".equals(string)) {
                object3 = "RIPEMD160withECDSA";
            }
        }
        try {
            int n;
            object2 = Signature.getInstance((String)object3);
            ((Signature)object2).initSign((PrivateKey)key);
            byte[] byArray = new byte[20];
            while ((n = inputStream.read(byArray)) != -1) {
                ((Signature)object2).update(byArray, 0, n);
            }
            return SWCard.unwrapSignature(((Signature)object2).sign(), (String)object3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            object = "Algorithm + '" + (String)object3 + "' not supported for signing.";
            log.info((String)object, noSuchAlgorithmException);
            throw new SignatureCardException((String)object, noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            object = "Signing failed.";
            log.info((String)object, signatureException);
            throw new SignatureCardException((String)object, signatureException);
        }
        catch (InvalidKeyException invalidKeyException) {
            object = "Key not valid for algorithm + '" + (String)object3 + "'.";
            log.info((String)object, invalidKeyException);
            throw new SignatureCardException((String)object, invalidKeyException);
        }
        catch (IOException iOException) {
            object = "Error unwrapping signature value.";
            log.info((String)object, iOException);
            throw new SignatureCardException((String)object, iOException);
        }
    }

    private static byte[] unwrapSignature(byte[] byArray, String string) throws IOException {
        byte[] byArray2 = byArray;
        log.debug("Checking if unwrapping necessary for " + string);
        if ("SHA1withECDSA".equals(string) || "SHA256withECDSA".equals(string) || "RIPEMD160withECDSA".equals(string)) {
            log.debug("Unwrapping signature");
            ASN1 aSN1 = new ASN1(byArray);
            byte[] byArray3 = aSN1.getElementAt(0).gvBigInteger().toByteArray();
            int n = byArray3.length;
            int n2 = 0;
            if (byArray3[0] == 0) {
                --n;
                ++n2;
            }
            byte[] byArray4 = aSN1.getElementAt(1).gvBigInteger().toByteArray();
            int n3 = byArray4.length;
            int n4 = 0;
            if (byArray4[0] == 0) {
                --n3;
                ++n4;
            }
            byArray2 = new byte[n + n3];
            System.arraycopy(byArray3, n2, byArray2, 0, n);
            System.arraycopy(byArray4, n4, byArray2, n, n3);
        }
        return byArray2;
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public void disconnect(boolean bl) {
    }

    @Override
    public void reset() throws SignatureCardException {
    }

    static {
        log = LoggerFactory.getLogger(SWCard.class);
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("file.separator");
        swCardDir = string + string2 + BKU_USER_DIR + string2 + SWCARD_DIR;
        String string3 = System.getProperty("jnlp.mocca.swcard.directory");
        if (string3 != null) {
            File file = new File(string3);
            if (!file.isAbsolute()) {
                string3 = string + string2 + BKU_USER_DIR + string2 + string3;
                file = new File(string3);
            }
            if (file.isDirectory()) {
                swCardDir = string3;
            }
        }
    }
}

