/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.TimeoutException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.SMCCHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SEIdentityCard
extends AbstractSignatureCard
implements SignatureCard {
    private static final byte[] SIGDATA_PREFIX = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static final PinInfo PIN_SPEC = new PinInfo(6, 8, ".", "at/gv/egiz/smcc/SEIdentityCard", "pin", -126, null, -1);
    private final Logger log = LoggerFactory.getLogger(SEIdentityCard.class);

    @Override
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        MessageDigest messageDigest;
        this.log.debug("Trying to create signature..");
        CardChannel cardChannel = this.getCardChannel();
        try {
            this.selectFile(cardChannel, new byte[]{80, 21, 80, 22, 75, 2});
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error selecting file.", cardException);
        }
        try {
            this.verifyPINLoop(cardChannel, PIN_SPEC, pINGUI);
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error verifying PIN.", cardException);
        }
        this.setMSE(cardChannel);
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.log.error("Failed to get MessageDigest.", noSuchAlgorithmException);
            throw new SignatureCardException(noSuchAlgorithmException);
        }
        try {
            int n;
            byte[] byArray = new byte[messageDigest.getDigestLength()];
            while ((n = inputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            byArray = messageDigest.digest();
            byte[] byArray2 = new byte[SIGDATA_PREFIX.length + byArray.length];
            System.arraycopy(SIGDATA_PREFIX, 0, byArray2, 0, SIGDATA_PREFIX.length);
            System.arraycopy(byArray, 0, byArray2, SIGDATA_PREFIX.length, byArray.length);
            CommandAPDU commandAPDU = new CommandAPDU(0, 42, -98, -102, byArray2);
            ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
            if (responseAPDU.getSW() != 36864) {
                throw new SignatureCardException("Error creating signature: " + Integer.toHexString(responseAPDU.getSW()));
            }
            return responseAPDU.getData();
        }
        catch (IOException iOException) {
            throw new SignatureCardException("Error creating signature.", iOException);
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error creating signature.", cardException);
        }
    }

    @Override
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException, InterruptedException {
        this.log.debug("Trying to fetch certificate..");
        CardChannel cardChannel = this.getCardChannel();
        byte[] byArray = null;
        try {
            byArray = this.selectFile(cardChannel, new byte[]{80, 21, 80, 22, 67, 50});
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error selecting card file.", cardException);
        }
        if (byArray == null) {
            throw new SignatureCardException("Could not retireve FCI for certificate file.");
        }
        byte[] byArray2 = null;
        try {
            byArray2 = this.executeReadBinary(cardChannel, ISO7816Utils.getLengthFromFCx(byArray));
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error reading certificate from card.", cardException);
        }
        return byArray2;
    }

    @Override
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    private void setMSE(CardChannel cardChannel) throws SignatureCardException {
        byte[] byArray = new byte[]{-128, 1, 2, -127, 2, 75, 2};
        CommandAPDU commandAPDU = new CommandAPDU(0, 34, 65, -74, byArray);
        try {
            ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
            if (responseAPDU.getSW() != 36864) {
                throw new SignatureCardException("Error setting DST: " + Integer.toHexString(responseAPDU.getSW()));
            }
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error setting DST.", cardException);
        }
    }

    private byte[] selectFile(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, -92, 8, 0, byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("Unexpected result from card: " + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    private byte[] executeReadBinary(CardChannel cardChannel, int n) throws CardException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (!bl) {
            n4 = n - n2 > 239 ? 239 : n - n2;
            byte[] byArray = SMCCHelper.toByteArray(n3);
            ResponseAPDU responseAPDU = this.readFromCard(cardChannel, byArray[0], byArray[1], (byte)n4);
            if (responseAPDU.getSW1() == 108) {
                responseAPDU = this.readFromCard(cardChannel, byArray[0], byArray[1], (byte)responseAPDU.getSW2());
                bl = true;
            }
            try {
                byteArrayOutputStream.write(responseAPDU.getData());
            }
            catch (IOException iOException) {
                this.log.error("Error executing secure read binary.", iOException);
                throw new CardException("Error reading data from card", iOException);
            }
            n3 = n2 += responseAPDU.getData().length;
            if (n2 != n) continue;
            bl = true;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private ResponseAPDU readFromCard(CardChannel cardChannel, byte by, byte by2, byte by3) throws CardException {
        byte[] byArray = new byte[]{0, -80, by, by2, by3};
        CommandAPDU commandAPDU = new CommandAPDU(byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        return responseAPDU;
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) >= -1) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws SignatureCardException, LockedException, NotActivatedException, InterruptedException, CardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{0, 32, 0, pinInfo.getKID(), 8, 0, 0, 0, 0, 0, 0, 0, 0}, 0, 2, 8);
        ResponseAPDU responseAPDU = this.reader.verify(cardChannel, verifyAPDUSpec, pINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            return -2;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 25344: {
                return -1;
            }
            case 25600: {
                throw new TimeoutException();
            }
            case 27011: {
                throw new LockedException();
            }
            case 27012: {
                throw new NotActivatedException();
            }
            case 27013: {
                throw new NotActivatedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        throw new SignatureCardException(string);
    }
}

