/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.FileNotFoundException;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SecurityStatusNotSatisfiedException;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.SMCCHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtEidCard
extends AbstractSignatureCard {
    private final Logger log = LoggerFactory.getLogger(PtEidCard.class);
    private static final byte[] AID_APPLET = new byte[]{96, 70, 50, -1, 0, 0, 2};
    private static final byte[] DF_ISSUES = new byte[]{95, 0};
    private static final byte[] EF_SIGN_CERT = new byte[]{-17, 8};
    private static final PinInfo QS_PIN_SPEC = new PinInfo(4, 4, "[0-9]", "at/gv/egiz/smcc/PtEidCard", "sig.pin", -126, DF_ISSUES, -1);

    @Override
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException, InterruptedException {
        try {
            CardChannel cardChannel = this.getCardChannel();
            this.execSELECT_AID(cardChannel, AID_APPLET);
            this.execSELECT_FID(cardChannel, DF_ISSUES);
            byte[] byArray = this.execSELECT_FID(cardChannel, EF_SIGN_CERT);
            int n = ISO7816Utils.getLengthFromFCx(byArray);
            byte[] byArray2 = ISO7816Utils.readTransparentFileTLV(cardChannel, n, (byte)48);
            if (byArray2 == null) {
                throw new NotActivatedException();
            }
            return byArray2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NotActivatedException();
        }
        catch (CardException cardException) {
            this.log.info("Failed to get certificate.", cardException);
            throw new SignatureCardException(cardException);
        }
    }

    @Override
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    @Override
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        int n;
        MessageDigest messageDigest;
        if (!"http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string)) {
            throw new SignatureCardException("Card does not support algorithm " + string + ".");
        }
        byte[] byArray = new byte[]{-128, 1, 18, -124, 1, 1};
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.log.error("Failed to get MessageDigest.", noSuchAlgorithmException);
            throw new SignatureCardException(noSuchAlgorithmException);
        }
        byte[] byArray2 = new byte[messageDigest.getDigestLength()];
        while ((n = inputStream.read(byArray2)) != -1) {
            messageDigest.update(byArray2, 0, n);
        }
        byArray2 = messageDigest.digest();
        try {
            CardChannel cardChannel = this.getCardChannel();
            this.execSELECT_AID(cardChannel, AID_APPLET);
            this.execSELECT_FID(cardChannel, DF_ISSUES);
            this.verifyPINLoop(cardChannel, QS_PIN_SPEC, pINGUI);
            this.execMSE(cardChannel, 115, 3, null);
            this.execMSE(cardChannel, 65, 182, byArray);
            this.execPSO_HASH(cardChannel, byArray2);
            return this.execPSO_COMPUTE_DIGITAL_SIGNATURE(cardChannel);
        }
        catch (CardException cardException) {
            this.log.warn("Failed to execute command.", cardException);
            throw new SignatureCardException("Failed to access card.", cardException);
        }
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) >= -1) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws SignatureCardException, LockedException, NotActivatedException, InterruptedException, CardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{0, 32, 0, pinInfo.getKID(), 8, -1, -1, -1, -1, -1, -1, -1, -1}, 0, 2, 8);
        ResponseAPDU responseAPDU = this.reader.verify(cardChannel, verifyAPDUSpec, pINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            return -2;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 25344: {
                return -1;
            }
            case 27011: {
                throw new LockedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        throw new SignatureCardException(string);
    }

    protected void execSELECT_AID(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 4, 12, byArray, 256));
        if (responseAPDU.getSW() == 27266) {
            String string = "File or application not found FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select application FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.error(string);
            throw new SignatureCardException(string);
        }
    }

    protected byte[] execSELECT_FID(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 0, 0, byArray, 256));
        if (responseAPDU.getSW() == 27266) {
            String string = "File or application not found FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select application FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.error(string);
            throw new SignatureCardException(string);
        }
        return responseAPDU.getBytes();
    }

    protected void execMSE(CardChannel cardChannel, int n, int n2, byte[] byArray) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = byArray == null ? cardChannel.transmit(new CommandAPDU(0, 34, n, n2, 256)) : cardChannel.transmit(new CommandAPDU(0, 34, n, n2, byArray, 256));
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("MSE:SET failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    protected void execPSO_HASH(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length + 2);
        try {
            byteArrayOutputStream.write(144);
            byteArrayOutputStream.write(byArray.length);
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new SignatureCardException(iOException);
        }
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 42, 144, 160, byteArrayOutputStream.toByteArray()));
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("PSO - HASH failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    protected byte[] execPSO_COMPUTE_DIGITAL_SIGNATURE(CardChannel cardChannel) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 42, 158, 154, 20));
        if (responseAPDU.getSW() == 27010) {
            throw new SecurityStatusNotSatisfiedException();
        }
        if (responseAPDU.getSW() == 27011) {
            throw new LockedException();
        }
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("PSO: COMPUTE DIGITAL SIGNATURE failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }
}

