/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.CIOCertificateDirectory;
import at.gv.egiz.smcc.LtEIDCIOCertificate;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.TLVSequence;
import java.io.IOException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class LtEIDCIOCertificateDirectory
extends CIOCertificateDirectory {
    public LtEIDCIOCertificateDirectory(byte[] byArray) {
        super(byArray);
    }

    @Override
    protected void addCIOCertificate(byte[] byArray) throws IOException {
        LtEIDCIOCertificate ltEIDCIOCertificate = new LtEIDCIOCertificate(byArray);
        log.debug("adding {}", (Object)ltEIDCIOCertificate);
        this.cios.add(ltEIDCIOCertificate);
    }

    @Override
    protected byte[] executeSelect(CardChannel cardChannel) throws CardException {
        byte[] byArray = null;
        if (this.fid != null && this.fid.length > 2 && this.fid[0] == 63 && this.fid[1] == 0) {
            byArray = new byte[this.fid.length - 2];
            System.arraycopy(this.fid, 2, byArray, 0, this.fid.length - 2);
        } else {
            byArray = this.fid;
        }
        CommandAPDU commandAPDU = new CommandAPDU(0, -92, 8, 4, byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new CardException("Error selecting File - unexpected response from card: " + Integer.toHexString(responseAPDU.getSW()));
        }
        byte[] byArray2 = new TLVSequence(responseAPDU.getBytes()).getValue(98);
        byte[] byArray3 = new TLVSequence(byArray2).getValue(130);
        return byArray3;
    }

    @Override
    protected byte[] doReadTransparentFile(CardChannel cardChannel) throws CardException, SignatureCardException {
        return ISO7816Utils.readTransparentFile(cardChannel, 238);
    }
}

