/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractISCard;
import at.gv.egiz.smcc.CancelledException;
import at.gv.egiz.smcc.Exclusive;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.TimeoutException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.SMCCHelper;
import at.gv.egiz.smcc.util.TLV;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISMAESTROCard
extends AbstractISCard
implements SignatureCard {
    private static final byte[] APPLET_ID = new byte[]{-96, 0, 0, 0, 99, 80, 75, 67, 83, 45, 49, 53};
    private static final String CERTIFICATE_IDENTIFIER = "Undirritun";
    private static final PinInfo PIN_SPEC = new PinInfo(6, 6, "[0-9]", "at/gv/egiz/smcc/ISMAESTROCard", "sig.pin", 2, new byte[0], -1);
    private final Logger log = LoggerFactory.getLogger(ISMAESTROCard.class);

    @Override
    @Exclusive
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        CardChannel cardChannel = this.getCardChannel();
        byte[] byArray = null;
        try {
            int n;
            MessageDigest messageDigest;
            this.selectApplet(cardChannel);
            this.executeMSERestore(cardChannel);
            this.selectFile(cardChannel, new byte[]{69, 65});
            this.verifyPINLoop(cardChannel, PIN_SPEC, pINGUI);
            this.executeMSESet(cardChannel);
            try {
                messageDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.log.error("Failed to get MessageDigest.", noSuchAlgorithmException);
                throw new SignatureCardException(noSuchAlgorithmException);
            }
            byte[] byArray2 = new byte[messageDigest.getDigestLength()];
            while ((n = inputStream.read(byArray2)) != -1) {
                messageDigest.update(byArray2, 0, n);
            }
            byArray2 = messageDigest.digest();
            byArray = this.executePSOCDS(cardChannel, byArray2);
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error creating signature.", cardException);
        }
        return byArray;
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) >= -1) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws SignatureCardException, LockedException, NotActivatedException, InterruptedException, CardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{-128, 32, 0, pinInfo.getKID(), 6, 0, 0, 0, 0, 0, 0}, 0, 2, 6);
        VerifyAPDUSpec verifyAPDUSpec2 = verifyAPDUSpec;
        ResponseAPDU responseAPDU = this.reader.verify(cardChannel, verifyAPDUSpec2, pINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            return -2;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 25344: {
                return -1;
            }
            case 25600: {
                throw new TimeoutException();
            }
            case 27011: {
                throw new LockedException();
            }
            case 27012: {
                throw new NotActivatedException();
            }
            case 27013: {
                throw new NotActivatedException();
            }
            case 26368: {
                return this.verifyTestCard(cardChannel, pinInfo, pINGUI, n);
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        throw new SignatureCardException(string);
    }

    private int verifyTestCard(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws CancelledException, InterruptedException, CardException, SignatureCardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{-128, 32, 0, pinInfo.getKID(), 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, 0, 2, 6);
        VerifyAPDUSpec verifyAPDUSpec2 = verifyAPDUSpec;
        ResponseAPDU responseAPDU = this.reader.verify(cardChannel, verifyAPDUSpec2, pINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            return -2;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 25344: {
                return -1;
            }
            case 25600: {
                throw new TimeoutException();
            }
            case 27011: {
                throw new LockedException();
            }
            case 27012: {
                throw new NotActivatedException();
            }
            case 27013: {
                throw new NotActivatedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        throw new SignatureCardException(string);
    }

    private byte[] executePSOCDS(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        byte[] byArray2 = new byte[byArray.length + OID.length];
        System.arraycopy(OID, 0, byArray2, 0, OID.length);
        System.arraycopy(byArray, 0, byArray2, OID.length, byArray.length);
        CommandAPDU commandAPDU = new CommandAPDU(-128, 42, -98, -102, byArray2);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("Unexpected Response to PSO CDS: " + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    private void executeMSESet(CardChannel cardChannel) throws CardException, SignatureCardException {
        CommandAPDU commandAPDU = new CommandAPDU(-128, 34, 65, -74, new byte[]{-128, 1, 1, -127, 2, 97, 1, -124, 1, 0});
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("Unexpected Response to SET MSE: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    private void executeMSERestore(CardChannel cardChannel) throws CardException, SignatureCardException {
        CommandAPDU commandAPDU = new CommandAPDU(-128, 34, -13, 1);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("Unexpected Response to RESTORE MSE: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    @Override
    @Exclusive
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        byte[] byArray = null;
        try {
            this.selectApplet(cardChannel);
            byte[] byArray2 = this.selectFile(cardChannel, new byte[]{69, 65});
            TLV tLV = new TLV(byArray2, 0);
            int n = this.toInt(tLV.getValue());
            byte[] byArray3 = this.executeReadBinary(cardChannel, n);
            byArray2 = this.selectFile(cardChannel, new byte[]{68, 4});
            tLV = new TLV(byArray2, 0);
            n = this.toInt(tLV.getValue());
            byte[] byArray4 = this.executeReadBinary(cardChannel, n);
            byArray = this.retrieveSigningCertificate(byArray3, byArray4, CERTIFICATE_IDENTIFIER);
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error reading certificate.", cardException);
        }
        catch (IOException iOException) {
            throw new SignatureCardException("Error reading certificate.", iOException);
        }
        return byArray;
    }

    private byte[] selectFile(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        CommandAPDU commandAPDU = new CommandAPDU(-128, -92, 0, 0, byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("Error selecting DF. Unexpected response from card: " + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    private byte[] executeReadBinary(CardChannel cardChannel, int n) throws CardException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (!bl) {
            byte by = n - n2 < 255 ? (byte)(n - n2) : (byte)-1;
            byte[] byArray = SMCCHelper.toByteArray(n3);
            ResponseAPDU responseAPDU = this.readFromCard(cardChannel, byArray[0], byArray[1], by);
            if (responseAPDU.getSW1() == 108) {
                responseAPDU = this.readFromCard(cardChannel, byArray[0], byArray[1], (byte)responseAPDU.getSW2());
            }
            if (responseAPDU.getSW() == 26368) {
                bl = true;
            }
            try {
                byteArrayOutputStream.write(responseAPDU.getData());
            }
            catch (IOException iOException) {
                this.log.error("Error executing secure read binary.", iOException);
                throw new CardException("Error reading data from card", iOException);
            }
            if ((n2 += responseAPDU.getData().length) >= n) {
                bl = true;
            }
            n3 = n2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private ResponseAPDU readFromCard(CardChannel cardChannel, byte by, byte by2, byte by3) throws CardException {
        byte[] byArray = new byte[]{-128, -80, by, by2, by3};
        CommandAPDU commandAPDU = new CommandAPDU(byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        return responseAPDU;
    }

    @Override
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    @Override
    protected byte[] getAppletID() {
        return APPLET_ID;
    }
}

