/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.Exclusive;
import at.gv.egiz.smcc.PINMgmtSignatureCard;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclSignatureCardProxy
implements InvocationHandler {
    private final Logger log = LoggerFactory.getLogger(ExclSignatureCardProxy.class);
    private static final Method init;
    private SignatureCard signatureCard;

    public ExclSignatureCardProxy(SignatureCard signatureCard) {
        this.signatureCard = signatureCard;
    }

    public static SignatureCard newInstance(SignatureCard signatureCard) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        arrayList.add(SignatureCard.class);
        if (PINMgmtSignatureCard.class.isAssignableFrom(signatureCard.getClass())) {
            arrayList.add(PINMgmtSignatureCard.class);
        }
        ClassLoader classLoader = signatureCard.getClass().getClassLoader();
        return (SignatureCard)Proxy.newProxyInstance(classLoader, arrayList.toArray(new Class[arrayList.size()]), (InvocationHandler)new ExclSignatureCardProxy(signatureCard));
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Card card = null;
        Method method2 = this.signatureCard.getClass().getMethod(method.getName(), method.getParameterTypes());
        if (method2.isAnnotationPresent(Exclusive.class)) {
            card = (Card)(method.equals(init) ? objectArray[0] : this.signatureCard.getCard());
        }
        if (card != null) {
            try {
                this.log.trace("Invoking method {}() with exclusive access.", (Object)method.getName());
                card.beginExclusive();
            }
            catch (CardException cardException) {
                this.log.info("Failed to get exclusive access to signature card {}.", (Object)this.signatureCard);
                throw new SignatureCardException(cardException);
            }
        }
        try {
            Object object2 = method.invoke((Object)this.signatureCard, objectArray);
            return object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        finally {
            if (card != null) {
                card.endExclusive();
            }
        }
    }

    static {
        try {
            init = SignatureCard.class.getMethod("init", Card.class, CardTerminal.class);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }
}

