/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.smartcardio.CardException;

public class DNIeCryptoUtil {
    private static final byte[] IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    public static X509Certificate createCertificate(byte[] byArray) throws CardException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            ((InputStream)byteArrayInputStream).close();
            return x509Certificate;
        }
        catch (Exception exception) {
            throw new CardException("Unable to create certificate.", exception);
        }
    }

    public static RSAPrivateKey createRSAPrivateKey(String string, String string2) throws CardException {
        RSAPrivateKey rSAPrivateKey;
        BigInteger bigInteger = new BigInteger(string, 16);
        BigInteger bigInteger2 = new BigInteger(string2, 16);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger, bigInteger2);
            rSAPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
        }
        catch (Exception exception) {
            throw new CardException("Unable to create private key.", exception);
        }
        return rSAPrivateKey;
    }

    public static RSAPublicKey createRSAPublicKey(String string, String string2) throws CardException {
        RSAPublicKey rSAPublicKey;
        BigInteger bigInteger = new BigInteger(string, 16);
        BigInteger bigInteger2 = new BigInteger(string2, 16);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
            rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new CardException("Unable to create public key.", exception);
        }
        return rSAPublicKey;
    }

    public static byte[] getRandomBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byte by;
            SecureRandom secureRandom = new SecureRandom();
            byArray[i] = by = (byte)secureRandom.nextInt(255);
        }
        return byArray;
    }

    public static byte[] computeSHA1Hash(byte[] byArray) throws CardException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CardException("Error computing SHA1 hash.", noSuchAlgorithmException);
        }
    }

    public static byte[] rsaEncrypt(Key key, byte[] byArray) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
        cipher.init(1, key);
        byte[] byArray2 = cipher.doFinal(byArray);
        return byArray2;
    }

    public static byte[] rsaDecrypt(Key key, byte[] byArray) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
        cipher.init(2, key);
        byte[] byArray2 = cipher.doFinal(byArray);
        return byArray2;
    }

    public static byte[] applyPadding(int n, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray2.length - 1] = -128;
        if (byArray2.length % n == 0) {
            return byArray2;
        }
        int n2 = byArray2.length / n + 1;
        byte[] byArray3 = new byte[n2 * n];
        Arrays.fill(byArray3, (byte)0);
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        return byArray3;
    }

    public static byte[] removePadding(byte[] byArray) throws CardException {
        for (int i = byArray.length - 1; i >= 0; --i) {
            byte by = byArray[i];
            if (by == 0) continue;
            if (by == -128) {
                byte[] byArray2 = new byte[i];
                System.arraycopy(byArray, 0, byArray2, 0, i);
                return byArray2;
            }
            throw new CardException("Wrong padding.");
        }
        throw new CardException("Error removing padding from data. Unexpected data format.");
    }

    public static byte[] calculateAPDUMAC(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws CardException {
        Cipher cipher;
        Object object;
        byte[] byArray4;
        Cipher cipher2;
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, 0, n, "DES");
        try {
            cipher2 = Cipher.getInstance("DES/CBC/NoPadding");
        }
        catch (Exception exception) {
            throw new CardException("Error creating DES cipher instance.", exception);
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(IV);
        int n2 = byArray.length;
        try {
            cipher2.init(1, (Key)secretKeySpec, ivParameterSpec);
        }
        catch (Exception exception) {
            throw new CardException("Error initializing DES cipher.", exception);
        }
        try {
            byArray4 = cipher2.doFinal(byArray3);
        }
        catch (Exception exception) {
            throw new CardException("Error applying DES cipher.", exception);
        }
        byte[] byArray5 = new byte[n];
        for (int i = 0; i < n2 - n; i += n) {
            System.arraycopy(byArray, i, byArray5, 0, n);
            object = DNIeCryptoUtil.xorByteArrays(byArray4, byArray5);
            try {
                byArray4 = cipher2.doFinal((byte[])object);
                continue;
            }
            catch (Exception exception) {
                throw new CardException("Error applying DES cipher.", exception);
            }
        }
        byte[] byArray6 = new byte[24];
        System.arraycopy(byArray2, 0, byArray6, 0, 16);
        System.arraycopy(byArray2, 0, byArray6, 16, 8);
        object = new SecretKeySpec(byArray6, "DESede");
        try {
            cipher = Cipher.getInstance("DESede/CBC/NoPadding");
        }
        catch (Exception exception) {
            throw new CardException("Error getting 3DES cipher instance.", exception);
        }
        ivParameterSpec = new IvParameterSpec(IV);
        try {
            cipher.init(1, (Key)object, ivParameterSpec);
        }
        catch (Exception exception) {
            throw new CardException("Error initializing 3DES cipher.", exception);
        }
        System.arraycopy(byArray, byArray.length - n, byArray5, 0, n);
        byte[] byArray7 = DNIeCryptoUtil.xorByteArrays(byArray4, byArray5);
        byte[] byArray8 = new byte[4];
        try {
            byArray4 = cipher.doFinal(byArray7);
        }
        catch (Exception exception) {
            throw new CardException("Error applying 3DES cipher.", exception);
        }
        System.arraycopy(byArray4, 0, byArray8, 0, 4);
        return byArray8;
    }

    public static byte[] xorByteArrays(byte[] byArray, byte[] byArray2) throws CardException {
        if (byArray == null || byArray2 == null || byArray.length != byArray2.length) {
            throw new CardException("Cannot xor byte arrays - invalid input.");
        }
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    public static byte[] perform3DESCipherOperation(byte[] byArray, byte[] byArray2, int n) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = new byte[24];
        System.arraycopy(byArray2, 0, byArray3, 0, 16);
        System.arraycopy(byArray2, 0, byArray3, 16, 8);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, "DESede");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(IV);
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
        cipher.init(n, (Key)secretKeySpec, ivParameterSpec);
        byte[] byArray4 = new byte[cipher.getOutputSize(byArray.length)];
        int n2 = cipher.update(byArray, 0, byArray.length, byArray4, 0);
        n2 += cipher.doFinal(byArray4, n2);
        return byArray4;
    }

    public static int getCutOffLength(byte[] byArray, int n) throws CardException {
        int n2 = byArray.length % n;
        if (byArray[n2 - 1] == 1) {
            return n2;
        }
        throw new CardException("Unable to reconstruct encrypted datablock.");
    }
}

