/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.ACOSATCard;
import at.gv.egiz.smcc.ACOSLIESignCard;
import at.gv.egiz.smcc.AbstractACOSCardInfoboxHandler;
import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.CancelledException;
import at.gv.egiz.smcc.ChangeReferenceDataAPDUSpec;
import at.gv.egiz.smcc.Exclusive;
import at.gv.egiz.smcc.FileNotFoundException;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PINMgmtSignatureCard;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SecurityStatusNotSatisfiedException;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.SignatureCardFactory;
import at.gv.egiz.smcc.TimeoutException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.pin.gui.ModifyPINGUI;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.SMCCHelper;
import at.gv.egiz.smcc.util.TransparentFileInputStream;
import iaik.me.asn1.ASN1;
import iaik.me.security.CryptoException;
import iaik.me.security.MessageDigest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACOSCard
extends AbstractSignatureCard
implements PINMgmtSignatureCard {
    public static final byte[] AID_DEC = new byte[]{-96, 0, 0, 1, 24, 69, 78};
    public static final byte[] DF_DEC = new byte[]{-33, 113};
    public static final byte[] AID_SIG = new byte[]{-96, 0, 0, 1, 24, 69, 67};
    public static final byte[] DF_SIG = new byte[]{-33, 112};
    public static final byte[] EF_C_CH_EKEY = new byte[]{-64, 1};
    public static final int EF_C_CH_EKEY_MAX_SIZE = 2000;
    public static final byte[] EF_C_CH_DS = new byte[]{-64, 2};
    public static final int EF_C_CH_DS_MAX_SIZE = 2000;
    public static final byte[] EF_PK_CH_EKEY = new byte[]{-80, 1};
    public static final byte[] EF_INFOBOX = new byte[]{-64, 2};
    public static final byte[] EF_INFO = new byte[]{-48, 2};
    public static final int EF_INFOBOX_MAX_SIZE = 1500;
    public static final byte KID_PIN_SIG = -127;
    public static final byte KID_PUK_SIG = -125;
    public static final byte KID_PIN_DEC = -127;
    public static final byte KID_PUK_DEC = -126;
    public static final byte KID_PIN_INF = -125;
    public static final byte KID_PUK_INF = -124;
    public static final byte[] DST_SIG = new byte[]{-124, 1, -120, -128, 1, 20};
    public static final byte[] AT_DEC = new byte[]{-124, 1, -120, -128, 1, 1};
    private final Logger log = LoggerFactory.getLogger(ACOSCard.class);
    protected PinInfo decPinInfo;
    protected PinInfo sigPinInfo;
    protected PinInfo infPinInfo;
    private AbstractACOSCardInfoboxHandler _infoboxHandler;
    protected int appVersion = -1;
    protected String cardType;

    @Override
    public void init(Card card, CardTerminal cardTerminal) {
        Object object;
        Object object2;
        super.init(card, cardTerminal);
        this.log.info("ACOS card found");
        try {
            object2 = this.getCardChannel();
            this.execSELECT_AID((CardChannel)object2, AID_SIG);
            this.execSELECT_FID((CardChannel)object2, EF_INFO);
            object = ISO7816Utils.openTransparentFileInputStream((CardChannel)object2, 8);
            this.appVersion = ((TransparentFileInputStream)object).read();
            this.log.info("a-sign premium application version = " + this.appVersion);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.appVersion = 1;
            this.log.info("a-sign premium application version = " + this.appVersion);
        }
        catch (SignatureCardException signatureCardException) {
            this.log.warn("Failed to execute command.", signatureCardException);
            this.appVersion = 0;
        }
        catch (IOException iOException) {
            this.log.warn("Failed to execute command.", iOException);
            this.appVersion = 0;
        }
        catch (CardException cardException) {
            this.log.warn("Failed to execute command.", cardException);
            this.appVersion = 0;
        }
        this.decPinInfo = new PinInfo(0, 8, "[0-9]", "at/gv/egiz/smcc/ACOSCard", "dec.pin", -127, AID_DEC, 10);
        this.sigPinInfo = new PinInfo(0, 8, "[0-9]", "at/gv/egiz/smcc/ACOSCard", "sig.pin", -127, AID_SIG, 10);
        this.infPinInfo = new PinInfo(0, 8, "[0-9]", "at/gv/egiz/smcc/ACOSCard", "inf.pin", -125, AID_DEC, 10);
        if (SignatureCardFactory.ENFORCE_RECOMMENDED_PIN_LENGTH) {
            this.decPinInfo.setRecLength(4);
            this.sigPinInfo.setRecLength(6);
            this.infPinInfo.setRecLength(4);
        }
        try {
            object2 = this.getCertificate(SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR, null);
            object = new ASN1((byte[])object2);
            ASN1 aSN1 = ((ASN1)object).getElementAt(0).getElementAt(3);
            String string = null;
            for (int i = 0; i < aSN1.getSize(); ++i) {
                if (!aSN1.getElementAt(i).getElementAt(0).getElementAt(0).gvString().equals("2.5.4.6")) continue;
                string = aSN1.getElementAt(i).getElementAt(0).getElementAt(1).gvString();
                break;
            }
            if (string == null) {
                this.log.debug("No Country found! - default to ACOS Austria.");
                this.cardType = "A-Sign premium";
                this._infoboxHandler = new ACOSATCard(this);
            } else if (string.equalsIgnoreCase("LI")) {
                this.log.debug("Identified lisign card.");
                this.cardType = "lisign";
                this._infoboxHandler = new ACOSLIESignCard(this);
            } else {
                this.log.debug("No lisign card - default to ACOS Austria.");
                this.cardType = "A-Sign premium";
                this._infoboxHandler = new ACOSATCard(this);
            }
            this.log.info("Identified {} card", (Object)this.cardType);
        }
        catch (SignatureCardException signatureCardException) {
            this.log.warn("Cannot determine card type by certificate. Using default.", signatureCardException);
            this._infoboxHandler = new ACOSATCard(this);
        }
        catch (IOException iOException) {
            this.log.warn("Cannot determine card type by certificate. Using default.", iOException);
            this._infoboxHandler = new ACOSATCard(this);
        }
        catch (RuntimeException runtimeException) {
            this.log.warn("Cannot determine card type by certificate. Using default.", runtimeException);
            this._infoboxHandler = new ACOSATCard(this);
        }
    }

    @Override
    @Exclusive
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException {
        byte[] byArray;
        byte[] byArray2;
        if (keyboxName == SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR) {
            byArray2 = AID_SIG;
            byArray = EF_C_CH_DS;
        } else if (keyboxName == SignatureCard.KeyboxName.CERTIFIED_KEYPAIR) {
            byArray2 = AID_DEC;
            byArray = EF_C_CH_EKEY;
        } else {
            throw new IllegalArgumentException("Keybox " + keyboxName + " not supported.");
        }
        try {
            byte[] byArray3;
            CardChannel cardChannel = this.getCardChannel();
            this.execSELECT_AID(cardChannel, byArray2);
            byte[] byArray4 = this.execSELECT_FID(cardChannel, byArray);
            int n = -1;
            if (this.getAppVersion() < 2) {
                n = ISO7816Utils.getLengthFromFCx(byArray4);
                this.log.debug("Size of selected file = {}.", (Object)n);
            }
            if ((byArray3 = ISO7816Utils.readTransparentFileTLV(cardChannel, n, (byte)48)) == null) {
                throw new NotActivatedException();
            }
            return byArray3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NotActivatedException();
        }
        catch (CardException cardException) {
            this.log.info("Failed to get certificate.", cardException);
            throw new SignatureCardException(cardException);
        }
    }

    @Override
    @Exclusive
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        return this._infoboxHandler.getInfobox(string, pINGUI, string2);
    }

    @Override
    @Exclusive
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        int n;
        MessageDigest messageDigest;
        ByteArrayOutputStream byteArrayOutputStream;
        block15: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(new byte[]{-124, 1, -120});
            byteArrayOutputStream.write(new byte[]{-128, 1});
            try {
                if (SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR.equals(keyboxName) && (string == null || "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1".equals(string))) {
                    byteArrayOutputStream.write(20);
                    messageDigest = MessageDigest.getInstance("SHA-1");
                    break block15;
                }
                if (SignatureCard.KeyboxName.CERTIFIED_KEYPAIR.equals(keyboxName) && (string == null || "http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string))) {
                    byteArrayOutputStream.write(18);
                    messageDigest = MessageDigest.getInstance("SHA-1");
                    break block15;
                }
                if (SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR.equals(keyboxName) && this.appVersion >= 2 && "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256".equals(string)) {
                    byteArrayOutputStream.write(68);
                    messageDigest = MessageDigest.getInstance("SHA-256");
                    break block15;
                }
                if (SignatureCard.KeyboxName.CERTIFIED_KEYPAIR.equals(keyboxName) && this.appVersion >= 2 && "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256".equals(string)) {
                    byteArrayOutputStream.write(65);
                    messageDigest = MessageDigest.getInstance("SHA-256");
                    break block15;
                }
                if (SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR.equals(keyboxName) && "http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160".equals(string)) {
                    byteArrayOutputStream.write(20);
                    messageDigest = MessageDigest.getInstance("RIPEMD160");
                    break block15;
                }
                throw new SignatureCardException("Card does not support signature algorithm " + string + ".");
            }
            catch (CryptoException cryptoException) {
                this.log.error("Failed to get MessageDigest.", cryptoException);
                throw new SignatureCardException(cryptoException);
            }
        }
        byte[] byArray = new byte[messageDigest.getDigestLength()];
        while ((n = inputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        byArray = messageDigest.digest();
        try {
            CardChannel cardChannel = this.getCardChannel();
            if (SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR.equals(keyboxName)) {
                this.execSELECT_AID(cardChannel, AID_SIG);
                this.execMSE(cardChannel, 65, 182, byteArrayOutputStream.toByteArray());
                this.verifyPINLoop(cardChannel, this.sigPinInfo, pINGUI);
                this.execPSO_HASH(cardChannel, byArray);
                return this.execPSO_COMPUTE_DIGITAL_SIGNATURE(cardChannel);
            }
            if (SignatureCard.KeyboxName.CERTIFIED_KEYPAIR.equals(keyboxName)) {
                this.execSELECT_AID(cardChannel, AID_DEC);
                this.execMSE(cardChannel, 65, 164, AT_DEC);
                while (true) {
                    try {
                        return this.execINTERNAL_AUTHENTICATE(cardChannel, byArray);
                    }
                    catch (SecurityStatusNotSatisfiedException securityStatusNotSatisfiedException) {
                        this.verifyPINLoop(cardChannel, this.decPinInfo, pINGUI);
                        continue;
                    }
                    break;
                }
            }
            throw new IllegalArgumentException("KeyboxName '" + keyboxName + "' not supported.");
        }
        catch (CardException cardException) {
            this.log.warn("Failed to execute command.", cardException);
            throw new SignatureCardException("Failed to access card.", cardException);
        }
    }

    public int getAppVersion() {
        return this.appVersion;
    }

    @Override
    public void verifyPIN(PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, CancelledException, TimeoutException, SignatureCardException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            this.execSELECT_AID(cardChannel, pinInfo.getContextAID());
            this.verifyPINLoop(cardChannel, pinInfo, pINGUI);
        }
        catch (CardException cardException) {
            this.log.info("Failed to verify PIN.", cardException);
            throw new SignatureCardException("Failed to verify PIN.", cardException);
        }
    }

    @Override
    public void changePIN(PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws LockedException, NotActivatedException, CancelledException, TimeoutException, SignatureCardException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            this.execSELECT_AID(cardChannel, pinInfo.getContextAID());
            this.changePINLoop(cardChannel, pinInfo, modifyPINGUI);
        }
        catch (CardException cardException) {
            this.log.info("Failed to change PIN.", cardException);
            throw new SignatureCardException("Failed to change PIN.", cardException);
        }
    }

    @Override
    public void activatePIN(PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws CancelledException, SignatureCardException, CancelledException, TimeoutException, InterruptedException {
        this.log.error("ACTIVATE PIN not supported by ACOS");
        throw new SignatureCardException("PIN activation not supported by this card.");
    }

    @Override
    public void unblockPIN(PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws CancelledException, SignatureCardException, InterruptedException {
        throw new SignatureCardException("Unblock PIN not supported.");
    }

    @Override
    public PinInfo[] getPinInfos() throws SignatureCardException {
        this.getCertificate(SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR, null);
        if (this.appVersion < 2) {
            return new PinInfo[]{this.decPinInfo, this.sigPinInfo, this.infPinInfo};
        }
        return new PinInfo[]{this.decPinInfo, this.sigPinInfo};
    }

    public String toString() {
        String string = "ACOS card: " + this.cardType;
        if (this.getAppVersion() > 0) {
            string = string + " (application version " + this.getAppVersion() + ")";
        }
        return string;
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws InterruptedException, CardException, SignatureCardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) > 0) {
        }
    }

    protected void changePINLoop(CardChannel cardChannel, PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws InterruptedException, CardException, SignatureCardException {
        int n = -1;
        while ((n = this.changePIN(cardChannel, pinInfo, modifyPINGUI, n)) > 0) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws InterruptedException, CardException, SignatureCardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{0, 32, 0, pinInfo.getKID(), 8, 0, 0, 0, 0, 0, 0, 0, 0}, 0, 2, 8);
        ResponseAPDU responseAPDU = this.reader.verify(cardChannel, verifyAPDUSpec, pINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            pinInfo.setActive(0xF & responseAPDU.getSW());
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 27011: {
                pinInfo.setBlocked();
                throw new LockedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        pinInfo.setUnknown();
        throw new SignatureCardException(string);
    }

    protected int changePIN(CardChannel cardChannel, PinInfo pinInfo, ModifyPINGUI modifyPINGUI, int n) throws CancelledException, InterruptedException, CardException, SignatureCardException {
        ChangeReferenceDataAPDUSpec changeReferenceDataAPDUSpec = new ChangeReferenceDataAPDUSpec(new byte[]{0, 36, 0, pinInfo.getKID(), 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 0, 2, 8);
        ResponseAPDU responseAPDU = this.reader.modify(cardChannel, changeReferenceDataAPDUSpec, modifyPINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            pinInfo.setActive(0xF & responseAPDU.getSW());
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 27011: {
                pinInfo.setBlocked();
                throw new LockedException();
            }
        }
        String string = "CHANGE REFERENCE DATA failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        pinInfo.setUnknown();
        throw new SignatureCardException(string);
    }

    protected void execMSE(CardChannel cardChannel, int n, int n2, byte[] byArray) throws SignatureCardException, CardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 34, n, n2, byArray));
        if (responseAPDU.getSW() != 36864) {
            String string = "MSE failed: SW=" + Integer.toHexString(responseAPDU.getSW());
            this.log.error(string);
            throw new SignatureCardException(string);
        }
    }

    protected byte[] execPSO_DECIPHER(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 0;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 42, 128, 134, byArray2, 256));
        if (responseAPDU.getSW() == 27010) {
            throw new SecurityStatusNotSatisfiedException();
        }
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("PSO - DECIPHER failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    protected void execPSO_HASH(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 42, 144, 129, byArray));
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("PSO - HASH failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    protected byte[] execPSO_COMPUTE_DIGITAL_SIGNATURE(CardChannel cardChannel) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 42, 158, 154, 256));
        if (responseAPDU.getSW() == 27010) {
            throw new SecurityStatusNotSatisfiedException();
        }
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("PSO - COMPUTE DIGITAL SIGNATURE failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    protected byte[] execINTERNAL_AUTHENTICATE(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        byte[] byArray2 = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4};
        byte[] byArray3 = new byte[byArray2.length + byArray.length + 1];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        byArray3[byArray2.length] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray3, byArray2.length + 1, byArray.length);
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 136, 16, 0, byArray3, 256));
        if (responseAPDU.getSW() == 27010) {
            throw new SecurityStatusNotSatisfiedException();
        }
        if (responseAPDU.getSW() == 27011) {
            throw new LockedException();
        }
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("INTERNAL AUTHENTICATE failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    protected byte[] execSELECT_AID(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 4, 0, byArray, 256));
        if (responseAPDU.getSW() == 27266) {
            String string = "File or application not found AID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select application AID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new SignatureCardException(string);
        }
        return responseAPDU.getBytes();
    }

    protected byte[] execSELECT_FID(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 0, 0, byArray, 256));
        if (responseAPDU.getSW() == 27266) {
            String string = "File or application not found FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select application FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.error(string);
            throw new SignatureCardException(string);
        }
        return responseAPDU.getBytes();
    }
}

