/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.jdkevents;

import com.oracle.jrockit.jfr.EventToken;
import com.oracle.jrockit.jfr.Producer;
import java.util.concurrent.atomic.AtomicLong;
import jdk.jfr.events.ErrorThrownEvent;
import jdk.jfr.events.ExceptionThrownEvent;
import jdk.jfr.events.ThrowablesEvent;
import oracle.jrockit.jfr.JFR;

public final class ThrowableTracer {
    private static EventToken exceptionThrownToken;
    private static EventToken errorThrownToken;
    private static AtomicLong numThrowables;

    public static void enable(JFR jFR, Producer producer) throws Exception {
        exceptionThrownToken = producer.addEvent(ExceptionThrownEvent.class);
        errorThrownToken = producer.addEvent(ErrorThrownEvent.class);
        producer.addEvent(ThrowablesEvent.class);
    }

    public static void traceError(Error error, String string) {
        if (error instanceof OutOfMemoryError) {
            return;
        }
        ErrorThrownEvent errorThrownEvent = new ErrorThrownEvent(errorThrownToken);
        errorThrownEvent.message = string;
        errorThrownEvent.thrownClass = error.getClass();
        errorThrownEvent.commit();
        ExceptionThrownEvent exceptionThrownEvent = new ExceptionThrownEvent(exceptionThrownToken);
        exceptionThrownEvent.message = string;
        exceptionThrownEvent.thrownClass = error.getClass();
        exceptionThrownEvent.commit();
        numThrowables.incrementAndGet();
    }

    public static void traceThrowable(Throwable throwable, String string) {
        ExceptionThrownEvent exceptionThrownEvent = new ExceptionThrownEvent(exceptionThrownToken);
        exceptionThrownEvent.message = string;
        exceptionThrownEvent.thrownClass = throwable.getClass();
        exceptionThrownEvent.commit();
        numThrowables.incrementAndGet();
    }

    public static long numThrowables() {
        return numThrowables.get();
    }

    static {
        numThrowables = new AtomicLong(0L);
    }
}

