/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.sourcemodel;

import com.sun.xml.internal.ws.policy.PolicyConstants;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.internal.ws.policy.sourcemodel.ModelNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public final class AssertionData
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4416256070795526315L;
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(AssertionData.class);
    private final QName name;
    private final String value;
    private final Map<QName, String> attributes;
    private ModelNode.Type type;
    private boolean optional;
    private boolean ignorable;

    public static AssertionData createAssertionData(QName qName) throws IllegalArgumentException {
        return new AssertionData(qName, null, null, ModelNode.Type.ASSERTION, false, false);
    }

    public static AssertionData createAssertionParameterData(QName qName) throws IllegalArgumentException {
        return new AssertionData(qName, null, null, ModelNode.Type.ASSERTION_PARAMETER_NODE, false, false);
    }

    public static AssertionData createAssertionData(QName qName, String string, Map<QName, String> map, boolean bl, boolean bl2) throws IllegalArgumentException {
        return new AssertionData(qName, string, map, ModelNode.Type.ASSERTION, bl, bl2);
    }

    public static AssertionData createAssertionParameterData(QName qName, String string, Map<QName, String> map) throws IllegalArgumentException {
        return new AssertionData(qName, string, map, ModelNode.Type.ASSERTION_PARAMETER_NODE, false, false);
    }

    AssertionData(QName qName, String string, Map<QName, String> map, ModelNode.Type type, boolean bl, boolean bl2) throws IllegalArgumentException {
        this.name = qName;
        this.value = string;
        this.optional = bl;
        this.ignorable = bl2;
        this.attributes = new HashMap<QName, String>();
        if (map != null && !map.isEmpty()) {
            this.attributes.putAll(map);
        }
        this.setModelNodeType(type);
    }

    private void setModelNodeType(ModelNode.Type type) throws IllegalArgumentException {
        if (type != ModelNode.Type.ASSERTION && type != ModelNode.Type.ASSERTION_PARAMETER_NODE) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0074_CANNOT_CREATE_ASSERTION_BAD_TYPE((Object)type, (Object)ModelNode.Type.ASSERTION, (Object)ModelNode.Type.ASSERTION_PARAMETER_NODE)));
        }
        this.type = type;
    }

    AssertionData(AssertionData assertionData) {
        this.name = assertionData.name;
        this.value = assertionData.value;
        this.attributes = new HashMap<QName, String>();
        if (!assertionData.attributes.isEmpty()) {
            this.attributes.putAll(assertionData.attributes);
        }
        this.type = assertionData.type;
    }

    protected AssertionData clone() throws CloneNotSupportedException {
        return (AssertionData)super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAttribute(QName qName) {
        Map<QName, String> map = this.attributes;
        synchronized (map) {
            return this.attributes.containsKey(qName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AssertionData)) {
            return false;
        }
        boolean bl = true;
        AssertionData assertionData = (AssertionData)object;
        boolean bl2 = bl = bl && this.name.equals(assertionData.name);
        bl = bl && (this.value == null ? assertionData.value == null : this.value.equals(assertionData.value));
        Map<QName, String> map = this.attributes;
        synchronized (map) {
            bl = bl && this.attributes.equals(assertionData.attributes);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeValue(QName qName) {
        Map<QName, String> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(qName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<QName, String> getAttributes() {
        Map<QName, String> map = this.attributes;
        synchronized (map) {
            return new HashMap<QName, String>(this.attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<QName, String>> getAttributesSet() {
        Map<QName, String> map = this.attributes;
        synchronized (map) {
            return new HashSet<Map.Entry<QName, String>>(this.attributes.entrySet());
        }
    }

    public QName getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int n = 17;
        n = 37 * n + this.name.hashCode();
        n = 37 * n + (this.value == null ? 0 : this.value.hashCode());
        Map<QName, String> map = this.attributes;
        synchronized (map) {
            n = 37 * n + this.attributes.hashCode();
        }
        return n;
    }

    public boolean isPrivateAttributeSet() {
        return "private".equals(this.getAttributeValue(PolicyConstants.VISIBILITY_ATTRIBUTE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeAttribute(QName qName) {
        Map<QName, String> map = this.attributes;
        synchronized (map) {
            return this.attributes.remove(qName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(QName qName, String string) {
        Map<QName, String> map = this.attributes;
        synchronized (map) {
            this.attributes.put(qName, string);
        }
    }

    public void setOptionalAttribute(boolean bl) {
        this.optional = bl;
    }

    public boolean isOptionalAttributeSet() {
        return this.optional;
    }

    public void setIgnorableAttribute(boolean bl) {
        this.ignorable = bl;
    }

    public boolean isIgnorableAttributeSet() {
        return this.ignorable;
    }

    public String toString() {
        return this.toString(0, new StringBuffer()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer toString(int n, StringBuffer stringBuffer) {
        String string = PolicyUtils.Text.createIndent(n);
        String string2 = PolicyUtils.Text.createIndent(n + 1);
        String string3 = PolicyUtils.Text.createIndent(n + 2);
        stringBuffer.append(string);
        if (this.type == ModelNode.Type.ASSERTION) {
            stringBuffer.append("assertion data {");
        } else {
            stringBuffer.append("assertion parameter data {");
        }
        stringBuffer.append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string2).append("namespace = '").append(this.name.getNamespaceURI()).append('\'').append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string2).append("prefix = '").append(this.name.getPrefix()).append('\'').append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string2).append("local name = '").append(this.name.getLocalPart()).append('\'').append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string2).append("value = '").append(this.value).append('\'').append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string2).append("optional = '").append(this.optional).append('\'').append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string2).append("ignorable = '").append(this.ignorable).append('\'').append(PolicyUtils.Text.NEW_LINE);
        Map<QName, String> map = this.attributes;
        synchronized (map) {
            if (this.attributes.isEmpty()) {
                stringBuffer.append(string2).append("no attributes");
            } else {
                stringBuffer.append(string2).append("attributes {").append(PolicyUtils.Text.NEW_LINE);
                for (Map.Entry<QName, String> entry : this.attributes.entrySet()) {
                    QName qName = entry.getKey();
                    stringBuffer.append(string3).append("name = '").append(qName.getNamespaceURI()).append(':').append(qName.getLocalPart());
                    stringBuffer.append("', value = '").append(entry.getValue()).append('\'').append(PolicyUtils.Text.NEW_LINE);
                }
                stringBuffer.append(string2).append('}');
            }
        }
        stringBuffer.append(PolicyUtils.Text.NEW_LINE).append(string).append('}');
        return stringBuffer;
    }

    public ModelNode.Type getNodeType() {
        return this.type;
    }
}

