/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.reflect;

import com.sun.xml.internal.bind.api.AccessorException;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.internal.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.internal.bind.v2.runtime.reflect.Lister;

final class PrimitiveArrayListerLong<BeanT>
extends Lister<BeanT, long[], Long, LongArrayPack> {
    private PrimitiveArrayListerLong() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Long.TYPE, new PrimitiveArrayListerLong());
    }

    @Override
    public ListIterator<Long> iterator(final long[] lArray, XMLSerializer xMLSerializer) {
        return new ListIterator<Long>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < lArray.length;
            }

            @Override
            public Long next() {
                return lArray[this.idx++];
            }
        };
    }

    @Override
    public LongArrayPack startPacking(BeanT BeanT, Accessor<BeanT, long[]> accessor) {
        return new LongArrayPack();
    }

    @Override
    public void addToPack(LongArrayPack longArrayPack, Long l) {
        longArrayPack.add(l);
    }

    @Override
    public void endPacking(LongArrayPack longArrayPack, BeanT BeanT, Accessor<BeanT, long[]> accessor) throws AccessorException {
        accessor.set(BeanT, longArrayPack.build());
    }

    @Override
    public void reset(BeanT BeanT, Accessor<BeanT, long[]> accessor) throws AccessorException {
        accessor.set(BeanT, new long[0]);
    }

    static final class LongArrayPack {
        long[] buf = new long[16];
        int size;

        LongArrayPack() {
        }

        void add(Long l) {
            if (this.buf.length == this.size) {
                long[] lArray = new long[this.buf.length * 2];
                System.arraycopy(this.buf, 0, lArray, 0, this.buf.length);
                this.buf = lArray;
            }
            if (l != null) {
                this.buf[this.size++] = l;
            }
        }

        long[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            long[] lArray = new long[this.size];
            System.arraycopy(this.buf, 0, lArray, 0, this.size);
            return lArray;
        }
    }
}

