/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.scio.osx;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import org.openecard.scio.osx.PCSC;
import org.openecard.scio.osx.PCSCException;
import org.openecard.scio.osx.TerminalImpl;

final class PCSCTerminals
extends CardTerminals {
    private static long contextId;
    private Map<String, ReaderState> stateMap;
    private static final Map<String, Reference<TerminalImpl>> terminals;

    PCSCTerminals() {
    }

    static synchronized void initContext() throws PCSCException {
        if (contextId == 0L) {
            contextId = PCSC.SCardEstablishContext(0);
        }
    }

    private static synchronized TerminalImpl implGetTerminal(String string) {
        TerminalImpl terminalImpl;
        Reference<TerminalImpl> reference = terminals.get(string);
        TerminalImpl terminalImpl2 = terminalImpl = reference != null ? reference.get() : null;
        if (terminalImpl != null) {
            return terminalImpl;
        }
        terminalImpl = new TerminalImpl(contextId, string);
        terminals.put(string, new WeakReference<TerminalImpl>(terminalImpl));
        return terminalImpl;
    }

    @Override
    public synchronized List<CardTerminal> list(CardTerminals.State state) throws CardException {
        if (state == null) {
            throw new NullPointerException();
        }
        try {
            String[] stringArray = PCSC.SCardListReaders(contextId);
            ArrayList<TerminalImpl> arrayList = new ArrayList<TerminalImpl>(stringArray.length);
            if (this.stateMap == null) {
                if (state == CardTerminals.State.CARD_INSERTION) {
                    state = CardTerminals.State.CARD_PRESENT;
                } else if (state == CardTerminals.State.CARD_REMOVAL) {
                    state = CardTerminals.State.CARD_ABSENT;
                }
            }
            block9: for (String string : stringArray) {
                TerminalImpl terminalImpl = PCSCTerminals.implGetTerminal(string);
                switch (state) {
                    case ALL: {
                        arrayList.add(terminalImpl);
                        continue block9;
                    }
                    case CARD_PRESENT: {
                        if (!((CardTerminal)terminalImpl).isCardPresent()) continue block9;
                        arrayList.add(terminalImpl);
                        continue block9;
                    }
                    case CARD_ABSENT: {
                        if (((CardTerminal)terminalImpl).isCardPresent()) continue block9;
                        arrayList.add(terminalImpl);
                        continue block9;
                    }
                    case CARD_INSERTION: {
                        ReaderState readerState = this.stateMap.get(string);
                        if (readerState == null || !readerState.isInsertion()) continue block9;
                        arrayList.add(terminalImpl);
                        continue block9;
                    }
                    case CARD_REMOVAL: {
                        ReaderState readerState = this.stateMap.get(string);
                        if (readerState == null || !readerState.isRemoval()) continue block9;
                        arrayList.add(terminalImpl);
                        continue block9;
                    }
                    default: {
                        throw new CardException("Unknown state: " + (Object)((Object)state));
                    }
                }
            }
            return Collections.unmodifiableList(arrayList);
        }
        catch (PCSCException pCSCException) {
            throw new CardException("list() failed", pCSCException);
        }
    }

    @Override
    public synchronized boolean waitForChange(long l) throws CardException {
        if (l < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative: " + l);
        }
        if (this.stateMap == null) {
            this.stateMap = new HashMap<String, ReaderState>();
            this.waitForChange(0L);
        }
        if (l == 0L) {
            l = -1L;
        }
        try {
            Object object;
            int n;
            String[] stringArray = PCSC.SCardListReaders(contextId);
            int n2 = stringArray.length;
            if (n2 == 0) {
                throw new IllegalStateException("No terminals available");
            }
            int[] nArray = new int[n2];
            ReaderState[] readerStateArray = new ReaderState[n2];
            for (n = 0; n < stringArray.length; ++n) {
                object = stringArray[n];
                ReaderState readerState = this.stateMap.get(object);
                if (readerState == null) {
                    readerState = new ReaderState();
                }
                readerStateArray[n] = readerState;
                nArray[n] = readerState.get();
            }
            nArray = PCSC.SCardGetStatusChange(contextId, l, nArray, stringArray);
            this.stateMap.clear();
            for (n = 0; n < n2; ++n) {
                object = readerStateArray[n];
                ((ReaderState)object).update(nArray[n]);
                this.stateMap.put(stringArray[n], (ReaderState)object);
            }
            return true;
        }
        catch (PCSCException pCSCException) {
            if (pCSCException.code == -2146435062) {
                return false;
            }
            throw new CardException("waitForChange() failed", pCSCException);
        }
    }

    /*
     * WARNING - void declaration
     */
    static List<CardTerminal> waitForCards(List<? extends CardTerminal> list, long l, boolean bl) throws CardException {
        long l2;
        if (l == 0L) {
            l = -1L;
            l2 = -1L;
        } else {
            l2 = 0L;
        }
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (CardTerminal object2 : list) {
            if (!(object2 instanceof TerminalImpl)) {
                throw new IllegalArgumentException("Invalid terminal type: " + object2.getClass().getName());
            }
            TerminalImpl terminalImpl = (TerminalImpl)object2;
            stringArray[n++] = terminalImpl.name;
        }
        Object object = new int[stringArray.length];
        Arrays.fill((int[])object, 0);
        try {
            void var9_10;
            do {
                object = PCSC.SCardGetStatusChange(contextId, l2, (int[])object, stringArray);
                l2 = l;
                Object var9_9 = null;
                for (n = 0; n < stringArray.length; ++n) {
                    boolean bl2;
                    boolean bl3 = bl2 = (object[n] & 0x20) != 0;
                    if (bl2 != bl) continue;
                    if (var9_10 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var9_10.add(PCSCTerminals.implGetTerminal(stringArray[n]));
                }
            } while (var9_10 == null);
            return Collections.unmodifiableList(var9_10);
        }
        catch (PCSCException pCSCException) {
            if (pCSCException.code == -2146435062) {
                return Collections.emptyList();
            }
            throw new CardException("waitForCard() failed", pCSCException);
        }
    }

    static {
        terminals = new HashMap<String, Reference<TerminalImpl>>();
    }

    private static class ReaderState {
        private int current = 0;
        private int previous = 0;

        ReaderState() {
        }

        int get() {
            return this.current;
        }

        void update(int n) {
            this.previous = this.current;
            this.current = n;
        }

        boolean isInsertion() {
            return !ReaderState.present(this.previous) && ReaderState.present(this.current);
        }

        boolean isRemoval() {
            return ReaderState.present(this.previous) && !ReaderState.present(this.current);
        }

        static boolean present(int n) {
            return (n & 0x20) != 0;
        }
    }
}

