/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.windows;

import lu.nowina.nexu.NexuException;
import lu.nowina.nexu.process.NativeProcessExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsRegistry.class);
    private static final String REGISTRY_INTERNET_SETTINGS_LOCATION = "HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
    private static final String PROXY_ENABLE_KEY = "ProxyEnable";
    private static final String PROXY_SERVER_KEY = "ProxyServer";
    private static final String PROXY_EXCEPTION_KEY = "ProxyOverride";
    private static final int RESULT_LOCATION = 5;

    public static boolean isProxyEnable() {
        String registryResult = WindowsRegistry.executeCommand(WindowsRegistry.buildCommand(REGISTRY_INTERNET_SETTINGS_LOCATION, PROXY_ENABLE_KEY));
        String[] array = registryResult.split("\\s+");
        byte result = Byte.decode(array[5]);
        return result != 0;
    }

    public static String getProxyServer() {
        try {
            String registryResult = WindowsRegistry.executeCommand(WindowsRegistry.buildCommand(REGISTRY_INTERNET_SETTINGS_LOCATION, PROXY_SERVER_KEY));
            String[] array = registryResult.split("\\s+");
            return array[5];
        }
        catch (NexuException e) {
            LOGGER.info("There is no proxy server declared");
            return null;
        }
    }

    public static String[] getBypassAddresses() {
        try {
            String registryResult = WindowsRegistry.executeCommand(WindowsRegistry.buildCommand(REGISTRY_INTERNET_SETTINGS_LOCATION, PROXY_EXCEPTION_KEY));
            String[] array = registryResult.split("\\s+");
            return array[5].split(";");
        }
        catch (NexuException e) {
            LOGGER.info("There is no address to bypass");
            return new String[0];
        }
    }

    private static String buildCommand(String location, String key) {
        return "reg query \"" + location + "\" /v " + key;
    }

    private static String executeCommand(String command) {
        NativeProcessExecutor executor = new NativeProcessExecutor(command, 10000);
        int resultCode = executor.getResultCode();
        if (resultCode != 0) {
            throw new NexuException("Result code of " + command + " is different from 0: " + resultCode);
        }
        return executor.getResult();
    }
}

