/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.view.ui;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import lu.nowina.nexu.flow.StageHelper;
import lu.nowina.nexu.view.ui.AbstractFeedbackUIOperationController;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResultController
extends AbstractFeedbackUIOperationController
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(StoreResultController.class.getName());
    @FXML
    private Button store;
    @FXML
    private Button forget;
    @FXML
    private Label message;

    public void initialize(URL location, ResourceBundle resources) {
        this.store.setOnAction(e -> {
            logger.info("Store for " + this.getFeedback().getSelectedCard().getAtr() + " parameters: " + (Object)((Object)this.getFeedback().getSelectedAPI()) + " - " + this.getFeedback().getApiParameter());
            this.signalEnd(this.getFeedback());
        });
        this.forget.setOnAction(e -> this.signalEnd(null));
    }

    @Override
    protected void doInit(Object ... params) {
        if (this.getFeedback().getSelectedCard() == null || this.getFeedback().getSelectedAPI() == null) {
            throw new IllegalArgumentException("Invalid Feedback (card: " + this.getFeedback().getSelectedCard() + ", api: " + (Object)((Object)this.getFeedback().getSelectedAPI()) + ")");
        }
        Platform.runLater(() -> {
            StageHelper.getInstance().setTitle(this.getApplicationName(), "store.configuration.title");
            this.message.setText(StringEscapeUtils.unescapeJava(MessageFormat.format(ResourceBundle.getBundle("bundles/nexu").getString("store.configuration.header"), this.getApplicationName())));
        });
    }
}

