/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.view.ui;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javax.xml.bind.JAXBException;
import lu.nowina.nexu.NexuException;
import lu.nowina.nexu.api.Feedback;
import lu.nowina.nexu.flow.StageHelper;
import lu.nowina.nexu.generic.DebugHelper;
import lu.nowina.nexu.view.ui.AbstractFeedbackUIOperationController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvideFeedbackController
extends AbstractFeedbackUIOperationController
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvideFeedbackController.class);
    @FXML
    private Button ok;
    @FXML
    private Button cancel;
    @FXML
    private Label message;
    @FXML
    private TextArea userComment;

    public void initialize(URL location, ResourceBundle resources) {
        this.ok.setOnAction(e -> {
            DebugHelper dh = new DebugHelper();
            Feedback feedback = null;
            try {
                feedback = dh.processError(new NexuException());
            }
            catch (IOException | JAXBException ex) {
                LOGGER.warn(ex.getMessage(), ex);
            }
            new Thread(() -> {
                try {
                    Desktop.getDesktop().browse(new URI(this.getAppConfig().getTicketUrl()));
                }
                catch (IOException | URISyntaxException ioe) {
                    LOGGER.error(ioe.getMessage());
                }
            }).start();
            this.signalEnd(feedback);
        });
        this.cancel.setOnAction(e -> this.signalUserCancel());
    }

    @Override
    protected void doInit(Object ... params) {
        StageHelper.getInstance().setTitle(this.getApplicationName(), "feedback.title");
        Platform.runLater(() -> this.message.setText(MessageFormat.format(ResourceBundle.getBundle("bundles/nexu").getString("feedback.message"), ResourceBundle.getBundle("bundles/nexu").getString("button.report.incident"), this.getApplicationName())));
    }
}

