/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.view.ui;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import lu.nowina.nexu.NexuLauncher;
import lu.nowina.nexu.ProxyConfigurer;
import lu.nowina.nexu.UserPreferences;
import lu.nowina.nexu.api.EnvironmentInfo;
import lu.nowina.nexu.api.OS;
import lu.nowina.nexu.view.core.AbstractUIOperationController;

public class PreferencesController
extends AbstractUIOperationController<Void>
implements Initializable {
    @FXML
    private Button ok;
    @FXML
    private Button cancel;
    @FXML
    private Button reset;
    @FXML
    private Label useSystemProxyLabel;
    @FXML
    private CheckBox useSystemProxy;
    @FXML
    private TextField proxyServer;
    @FXML
    private TextField proxyPort;
    @FXML
    private CheckBox proxyAuthentication;
    @FXML
    private TextField proxyUsername;
    @FXML
    private CheckBox useHttps;
    @FXML
    private PasswordField proxyPassword;
    private UserPreferences userPreferences;
    private BooleanProperty readOnly;
    private static final boolean isWindows = EnvironmentInfo.buildFromSystemProperties(System.getProperties()).getOs().equals((Object)OS.WINDOWS);

    private void init(ProxyConfigurer proxyConfigurer) {
        if (isWindows) {
            this.useSystemProxy.setSelected(proxyConfigurer.isUseSystemProxy());
        } else {
            this.useSystemProxy.setVisible(false);
            this.useSystemProxy.setManaged(false);
            this.useSystemProxyLabel.setVisible(false);
            this.useSystemProxyLabel.setManaged(false);
        }
        this.useHttps.setSelected(proxyConfigurer.isProxyUseHttps());
        this.proxyServer.setText(proxyConfigurer.getProxyServer());
        Integer proxyPortInt = proxyConfigurer.getProxyPort();
        this.proxyPort.setText(proxyPortInt != null ? proxyPortInt.toString() : "");
        this.proxyAuthentication.setSelected(proxyConfigurer.isProxyAuthentication());
        this.proxyUsername.setText(proxyConfigurer.getProxyUsername());
        this.proxyPassword.setText(proxyConfigurer.getProxyPassword());
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.readOnly = new SimpleBooleanProperty(false);
        this.ok.disableProperty().bind((ObservableValue)this.readOnly);
        this.reset.disableProperty().bind((ObservableValue)this.readOnly);
        this.useSystemProxy.disableProperty().bind((ObservableValue)this.readOnly);
        this.proxyServer.disableProperty().bind((ObservableValue)this.readOnly.or((ObservableBooleanValue)this.useSystemProxy.selectedProperty()));
        this.proxyPort.disableProperty().bind((ObservableValue)this.proxyServer.textProperty().length().lessThanOrEqualTo(0).or((ObservableBooleanValue)this.proxyServer.disabledProperty()));
        this.proxyAuthentication.disableProperty().bind((ObservableValue)this.readOnly.or((ObservableBooleanValue)this.proxyServer.textProperty().length().lessThanOrEqualTo(0).and((ObservableBooleanValue)this.useSystemProxy.selectedProperty().not())));
        this.useHttps.disableProperty().bind((ObservableValue)this.readOnly.or((ObservableBooleanValue)this.proxyServer.textProperty().length().lessThanOrEqualTo(0).and((ObservableBooleanValue)this.useSystemProxy.selectedProperty().not())));
        this.proxyUsername.disableProperty().bind((ObservableValue)this.proxyAuthentication.disabledProperty().or((ObservableBooleanValue)this.proxyAuthentication.selectedProperty().not()));
        this.proxyPassword.disableProperty().bind((ObservableValue)this.proxyAuthentication.disabledProperty().or((ObservableBooleanValue)this.proxyAuthentication.selectedProperty().not()));
        this.ok.setOnAction(evt -> {
            Integer port;
            try {
                port = this.proxyPort.isDisabled() ? null : Integer.valueOf(Integer.parseInt(this.proxyPort.getText()));
            }
            catch (NumberFormatException e) {
                this.proxyPort.setTooltip(new Tooltip(resources.getString("preferences.controller.invalid.port")));
                this.proxyPort.setStyle("-fx-text-box-border: red; -fx-focus-color: red;");
                return;
            }
            this.userPreferences.setUseSystemProxy(this.useSystemProxy.isDisabled() ? null : Boolean.valueOf(this.useSystemProxy.isSelected()));
            this.userPreferences.setProxyServer(this.proxyServer.isDisabled() ? null : this.proxyServer.getText());
            this.userPreferences.setProxyPort(port);
            this.userPreferences.setProxyAuthentication(this.proxyAuthentication.isDisabled() ? null : Boolean.valueOf(this.proxyAuthentication.isSelected()));
            this.userPreferences.setProxyUsername(this.proxyUsername.isDisabled() ? null : this.proxyUsername.getText());
            this.userPreferences.setProxyPassword(this.proxyPassword.isDisabled() ? null : this.proxyPassword.getText());
            this.userPreferences.setProxyUseHttps(this.useHttps.isDisabled() ? null : Boolean.valueOf(this.useHttps.isSelected()));
            NexuLauncher.getProxyConfigurer().updateValues(NexuLauncher.getConfig(), this.userPreferences);
            this.signalEnd(null);
        });
        this.cancel.setOnAction(e -> this.signalEnd(null));
        this.reset.setOnAction(e -> {
            this.userPreferences.clear();
            NexuLauncher.getProxyConfigurer().updateValues(NexuLauncher.getConfig(), this.userPreferences);
            this.signalEnd(null);
        });
    }

    @Override
    public void init(Object ... params) {
        ProxyConfigurer proxyConfigurer = (ProxyConfigurer)params[0];
        this.init(proxyConfigurer);
        this.userPreferences = (UserPreferences)params[1];
        this.readOnly.set(((Boolean)params[2]).booleanValue());
    }
}

