/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.view.ui;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.QCStatementOids;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.x509.CertificateToken;
import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import lu.nowina.nexu.flow.StageHelper;
import lu.nowina.nexu.flow.operation.CoreOperationStatus;
import lu.nowina.nexu.view.core.AbstractUIOperationController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeySelectionController
extends AbstractUIOperationController<DSSPrivateKeyEntry>
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(KeySelectionController.class.getName());
    private static final String ICON_UNLOCKED = "/images/unlocked.png";
    private static final String ICON_QC = "/images/medal.png";
    private static final String ICON_QCSD = "/images/quality.png";
    @FXML
    private Button select;
    @FXML
    private Button cancel;
    @FXML
    private Button back;
    @FXML
    private ListView<DSSPrivateKeyEntry> listView;

    public void initialize(URL location, final ResourceBundle resources) {
        this.select.setOnAction(event -> {
            DSSPrivateKeyEntry selectedItem = (DSSPrivateKeyEntry)this.listView.getSelectionModel().getSelectedItem();
            logger.info("Selected item " + selectedItem);
            if (selectedItem != null) {
                this.signalEnd(selectedItem);
            } else {
                this.signalEnd(null);
            }
        });
        this.cancel.setOnAction(e -> this.signalUserCancel());
        this.back.setOnAction(e -> this.signalEndWithStatus(CoreOperationStatus.BACK));
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.listView.setCellFactory(param -> new ListCell<DSSPrivateKeyEntry>(){

            protected void updateItem(DSSPrivateKeyEntry k, boolean bln) {
                super.updateItem((Object)k, bln);
                if (k != null) {
                    VBox vBoxLeft;
                    CertificateToken certificateToken = k.getCertificate();
                    Label lSubject = new Label();
                    lSubject.setText(DSSASN1Utils.getSubjectCommonName(certificateToken));
                    lSubject.setStyle("-fx-font-weight: bold;");
                    Label lEmitter = new Label();
                    lEmitter.setText(MessageFormat.format(resources.getString("key.selection.issuer.usage"), DSSASN1Utils.get(certificateToken.getIssuerX500Principal()).get("2.5.4.3"), KeySelectionController.this.createKeyUsageString(certificateToken, resources)));
                    Label lValidity = new Label();
                    SimpleDateFormat format = new SimpleDateFormat("dd MMMMMM yyyy");
                    String startDate = format.format(certificateToken.getNotBefore());
                    String endDate = format.format(certificateToken.getNotAfter());
                    lValidity.setText(MessageFormat.format(resources.getString("key.selection.validity"), startDate, endDate));
                    Hyperlink link = new Hyperlink(resources.getString("key.selection.certificate.open"));
                    link.setOnAction(actionEvent -> {
                        if (Desktop.isDesktopSupported()) {
                            try {
                                File tmpFile = File.createTempFile("certificate", ".crt");
                                tmpFile.deleteOnExit();
                                String certificateStr = DSSUtils.convertToPEM(certificateToken);
                                FileWriter writer = new FileWriter(tmpFile);
                                writer.write(certificateStr);
                                writer.close();
                                new Thread(() -> {
                                    try {
                                        Desktop.getDesktop().open(tmpFile);
                                    }
                                    catch (IOException e) {
                                        logger.error(e.getMessage(), e);
                                    }
                                }).start();
                            }
                            catch (Exception e) {
                                logger.error(e.getMessage(), e);
                            }
                        }
                    });
                    VBox vBox = new VBox(new Node[]{lSubject, lEmitter, lValidity, link});
                    try {
                        vBoxLeft = new VBox((Node[])KeySelectionController.this.getQCIcons(certificateToken).stream().toArray(ImageView[]::new));
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), e);
                        vBoxLeft = new VBox();
                    }
                    vBoxLeft.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
                    vBoxLeft.setAlignment(Pos.CENTER);
                    HBox hBox = new HBox(new Node[]{vBoxLeft, vBox});
                    this.setGraphic((Node)hBox);
                }
            }
        });
    }

    private List<ImageView> getQCIcons(CertificateToken certificateToken) throws IOException {
        ArrayList<ImageView> qcIconsImages = new ArrayList<ImageView>();
        List<String> qcStatements = DSSASN1Utils.getQCStatementsIdList(certificateToken);
        if (qcStatements.contains(QCStatementOids.QC_COMPLIANCE.getOid())) {
            qcIconsImages.add(this.fetchImage(ICON_QC));
        }
        if (qcStatements.contains(QCStatementOids.QC_SSCD.getOid())) {
            qcIconsImages.add(this.fetchImage(ICON_QCSD));
        }
        if (qcIconsImages.isEmpty()) {
            qcIconsImages.add(this.fetchImage(ICON_UNLOCKED));
        }
        return qcIconsImages;
    }

    private ImageView fetchImage(String imagePath) throws IOException {
        return new ImageView(new Image(this.getClass().getResource(imagePath).openStream()));
    }

    private String createKeyUsageString(CertificateToken token, ResourceBundle resources) {
        boolean[] keyUsages = token.getCertificate().getKeyUsage();
        if (keyUsages == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (keyUsages[0]) {
            builder.append(resources.getString("keyUsage.digitalSignature") + "\n");
        }
        if (keyUsages[1]) {
            builder.append(resources.getString("keyUsage.nonRepudiation") + "\n");
        }
        if (keyUsages[2]) {
            builder.append(resources.getString("keyUsage.keyEncipherment") + "\n");
        }
        if (keyUsages[3]) {
            builder.append(resources.getString("keyUsage.dataEncipherment") + "\n");
        }
        if (keyUsages[4]) {
            builder.append(resources.getString("keyUsage.keyAgreement") + "\n");
        }
        if (keyUsages[5]) {
            builder.append(resources.getString("keyUsage.keyCertSign") + "\n");
        }
        if (keyUsages[6]) {
            builder.append(resources.getString("keyUsage.crlSign") + "\n");
        }
        if (keyUsages[7]) {
            builder.append(resources.getString("keyUsage.encipherOnly") + "\n");
        }
        if (keyUsages[8]) {
            builder.append(resources.getString("keyUsage.decipherOnly") + "\n");
        }
        return builder.toString();
    }

    @Override
    public void init(Object ... params) {
        StageHelper.getInstance().setTitle((String)params[1], "key.selection.title");
        Boolean displayBackButton = (Boolean)params[2];
        this.back.setManaged(displayBackButton.booleanValue());
        this.back.setVisible(displayBackButton.booleanValue());
        List keys = (List)params[0];
        ObservableList items = FXCollections.observableArrayList((Collection)keys);
        this.listView.setItems(items);
        if (items.size() <= 5) {
            this.listView.setPrefHeight(100.0 * (double)items.size());
        } else {
            this.listView.setPrefHeight(500.0);
        }
    }
}

