/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.view.ui;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import lu.nowina.nexu.api.EnvironmentInfo;
import lu.nowina.nexu.api.OS;
import lu.nowina.nexu.api.ScAPI;
import lu.nowina.nexu.flow.StageHelper;
import lu.nowina.nexu.view.core.AbstractUIOperationController;

public class APISelectionController
extends AbstractUIOperationController<ScAPI>
implements Initializable {
    private static final boolean IS_WINDOWS = EnvironmentInfo.buildFromSystemProperties(System.getProperties()).getOs().equals((Object)OS.WINDOWS);
    @FXML
    private Button select;
    @FXML
    private Button cancel;
    @FXML
    private RadioButton mscapi;
    @FXML
    private RadioButton pkcs11;
    @FXML
    private RadioButton mocca;
    @FXML
    private ToggleGroup api;
    @FXML
    private Label message;

    public void initialize(URL location, ResourceBundle resources) {
        this.select.setOnAction(e -> this.signalEnd(this.getSelectedAPI()));
        this.cancel.setOnAction(e -> this.signalUserCancel());
        this.select.disableProperty().bind((ObservableValue)this.api.selectedToggleProperty().isNull());
        if (!IS_WINDOWS) {
            this.mscapi.setVisible(false);
            this.mscapi.setManaged(false);
        }
    }

    private ScAPI getSelectedAPI() {
        if (this.mscapi.isSelected()) {
            if (!IS_WINDOWS) {
                throw new IllegalStateException("MSCAPI not supported on platforms other than Windows!");
            }
            return ScAPI.MSCAPI;
        }
        if (this.pkcs11.isSelected()) {
            return ScAPI.PKCS_11;
        }
        if (this.mocca.isSelected()) {
            return ScAPI.MOCCA;
        }
        return null;
    }

    @Override
    public final void init(Object ... params) {
        StageHelper.getInstance().setTitle((String)params[0], "api.selection.title");
        Platform.runLater(() -> this.message.setText(MessageFormat.format(ResourceBundle.getBundle("bundles/nexu").getString("api.selection.header"), params[0])));
    }
}

