/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.systray;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.net.URL;
import lu.nowina.nexu.api.SystrayMenuItem;
import lu.nowina.nexu.api.flow.OperationFactory;
import lu.nowina.nexu.systray.SystrayMenuInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWTSystrayMenuInitializer
implements SystrayMenuInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AWTSystrayMenuInitializer.class.getName());

    @Override
    public void init(String tooltip, URL trayIconURL, OperationFactory operationFactory, SystrayMenuItem exitMenuItem, SystrayMenuItem ... systrayMenuItems) {
        if (SystemTray.isSupported()) {
            PopupMenu popup = new PopupMenu();
            for (SystrayMenuItem systrayMenuItem : systrayMenuItems) {
                MenuItem mi = new MenuItem(systrayMenuItem.getLabel());
                mi.addActionListener(l -> systrayMenuItem.getFutureOperationInvocation().call(operationFactory));
                popup.add(mi);
            }
            Image image = Toolkit.getDefaultToolkit().getImage(trayIconURL);
            TrayIcon trayIcon = new TrayIcon(image, tooltip, popup);
            trayIcon.setImageAutoSize(true);
            MenuItem mi = new MenuItem(exitMenuItem.getLabel());
            mi.addActionListener(l -> this.exit(operationFactory, exitMenuItem, trayIcon));
            popup.add(mi);
            try {
                SystemTray.getSystemTray().add(trayIcon);
            }
            catch (AWTException e) {
                LOGGER.error("Cannot add TrayIcon", e);
            }
        } else {
            LOGGER.error("System tray is currently not supported.");
        }
    }

    private void exit(OperationFactory operationFactory, SystrayMenuItem exitMenuItem, TrayIcon trayIcon) {
        SystemTray.getSystemTray().remove(trayIcon);
        exitMenuItem.getFutureOperationInvocation().call(operationFactory);
    }
}

