/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.keystore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import lu.nowina.nexu.DatabaseEventHandler;
import lu.nowina.nexu.ProductDatabase;
import lu.nowina.nexu.api.ConfiguredKeystore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="database")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class KeystoreDatabase
implements ProductDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeystoreDatabase.class.getName());
    @XmlElement(name="keystore")
    private List<ConfiguredKeystore> keystores;
    @XmlTransient
    private DatabaseEventHandler onAddRemoveAction;

    public final void add(ConfiguredKeystore keystore) {
        this.getKeystores0().add(keystore);
        this.onAddRemove();
    }

    public final void remove(ConfiguredKeystore keystore) {
        this.getKeystores0().remove(keystore);
        this.onAddRemove();
    }

    private void onAddRemove() {
        if (this.onAddRemoveAction != null) {
            this.onAddRemoveAction.execute(this);
        } else {
            LOGGER.warn("No DatabaseEventHandler define, the database cannot be stored");
        }
    }

    private List<ConfiguredKeystore> getKeystores0() {
        if (this.keystores == null) {
            this.keystores = new ArrayList<ConfiguredKeystore>();
        }
        return this.keystores;
    }

    public List<ConfiguredKeystore> getKeystores() {
        return Collections.unmodifiableList(this.getKeystores0());
    }

    @Override
    public void setOnAddRemoveAction(DatabaseEventHandler eventHandler) {
        this.onAddRemoveAction = eventHandler;
    }
}

