/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.jetty;

import lu.nowina.nexu.HttpServer;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.jetty.RequestProcessor;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;

public abstract class AbstractJettyServer
implements HttpServer {
    private NexuAPI api;
    private Server server;

    @Override
    public void setConfig(NexuAPI api) {
        this.api = api;
    }

    @Override
    public void start() throws Exception {
        this.server = new Server();
        this.server.setConnectors(this.getConnectors());
        Class<RequestProcessor> clazz = Class.forName(this.api.getAppConfig().getRequestProcessorClass()).asSubclass(RequestProcessor.class);
        RequestProcessor handler = clazz.newInstance();
        handler.setConfig(this.api);
        handler.setNexuHostname(this.api.getAppConfig().getNexuHostname());
        this.server.setHandler(handler);
        this.server.start();
    }

    @Override
    public void stop() throws Exception {
        this.server.stop();
        this.server = null;
    }

    @Override
    public void join() throws Exception {
        this.server.join();
    }

    protected NexuAPI getApi() {
        return this.api;
    }

    protected Server getServer() {
        return this.server;
    }

    protected abstract Connector[] getConnectors();
}

