/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.https;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import lu.nowina.nexu.NexuException;
import lu.nowina.nexu.jetty.AbstractJettyServer;
import lu.nowina.nexu.jetty.JettyListAwareServerConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyHttpsServer
extends AbstractJettyServer {
    @Override
    public Connector[] getConnectors() {
        HttpConfiguration http = new HttpConfiguration();
        JettyListAwareServerConnector connector = new JettyListAwareServerConnector(this.getServer());
        connector.addConnectionFactory(new HttpConnectionFactory(http));
        connector.setPorts(this.getApi().getAppConfig().getBindingPorts());
        connector.setHost(InetAddress.getLoopbackAddress().getCanonicalHostName());
        HttpConfiguration https = new HttpConfiguration();
        https.addCustomizer(new SecureRequestCustomizer());
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStore(this.openKeyStore(this.getApi().getAppConfig().getNexuHome(), this.getApi().getAppConfig().getApplicationName()));
        sslContextFactory.setKeyStorePassword("password");
        sslContextFactory.setKeyManagerPassword("password");
        JettyListAwareServerConnector sslConnector = new JettyListAwareServerConnector(this.getServer(), new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https));
        sslConnector.setPorts(this.getApi().getAppConfig().getBindingPortsHttps());
        sslConnector.setHost(InetAddress.getLoopbackAddress().getCanonicalHostName());
        return new Connector[]{connector, sslConnector};
    }

    private KeyStore openKeyStore(File nexuHome, String applicationName) {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            try (FileInputStream fis = new FileInputStream(new File(nexuHome, "web-server-keystore.jks"));
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                keyStore.load(bis, "password".toCharArray());
            }
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new NexuException(e);
        }
    }
}

