/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import lu.nowina.nexu.DatabaseEventHandler;
import lu.nowina.nexu.ProductDatabase;
import lu.nowina.nexu.generic.ConnectionInfo;
import lu.nowina.nexu.generic.SCInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="database")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SCDatabase
implements ProductDatabase {
    private static final Logger logger = LoggerFactory.getLogger(SCDatabase.class.getName());
    @XmlElement(name="smartcard")
    private List<SCInfo> smartcards;
    @XmlTransient
    private DatabaseEventHandler onAddAction;

    public final void add(String detectedAtr, ConnectionInfo cInfo) {
        SCInfo info = this.getInfo(detectedAtr);
        if (info == null) {
            info = new SCInfo();
            info.setAtr(detectedAtr);
            this.getSmartcards0().add(info);
        }
        info.getInfos().add(cInfo);
        this.onAdd();
    }

    private void onAdd() {
        if (this.onAddAction != null) {
            this.onAddAction.execute(this);
        } else {
            logger.warn("No DatabaseEventHandler define, the database cannot be stored");
        }
    }

    public SCInfo getInfo(String atr) {
        for (SCInfo i : this.getSmartcards()) {
            if (!i.getAtr().equals(atr)) continue;
            return i;
        }
        return null;
    }

    private List<SCInfo> getSmartcards0() {
        if (this.smartcards == null) {
            this.smartcards = new ArrayList<SCInfo>();
        }
        return this.smartcards;
    }

    public List<SCInfo> getSmartcards() {
        return Collections.unmodifiableList(this.getSmartcards0());
    }

    @Override
    public void setOnAddRemoveAction(DatabaseEventHandler onAddAction) {
        this.onAddAction = onAddAction;
    }
}

